/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.api;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import jayeson.lib.delivery.api.CoreComponent;
import jayeson.lib.delivery.api.NamedHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ITransport
extends CoreComponent {
    public static final Logger log = LoggerFactory.getLogger(ITransport.class);

    @Override
    default public void attach(ChannelPipeline pipeline) {
        ChannelHandler transportRouterBridge = pipeline.get("TRANSPORT_ROUTER_MARKER");
        if (transportRouterBridge == null) {
            log.error("No {} handler in the pipeline. No action taken", (Object)"TRANSPORT_ROUTER_MARKER");
            return;
        }
        for (NamedHandler namedHandler : this.getDefaultHandlers()) {
            log.trace("Adding {} BEFORE {}", (Object)namedHandler.getName(), (Object)"TRANSPORT_ROUTER_MARKER");
            pipeline.addBefore("TRANSPORT_ROUTER_MARKER", namedHandler.getName(), (ChannelHandler)namedHandler);
        }
    }
}

