/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.api.exceptions;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeliveryExceptionHandler
extends ChannelInboundHandlerAdapter
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(DeliveryExceptionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (cause instanceof PipelineException) {
                this.onException((PipelineException)cause);
            } else {
                log.error("Error in ExceptionHandler. Expecting exception of type PipelineException", cause);
            }
        }
        catch (Exception ex) {
            log.error("Error while handling Exception in ExceptionHandler", (Throwable)ex);
        }
    }

    public abstract void onException(PipelineException var1);

    @Override
    public String getName() {
        return "DELIVERY_EXCEPTION_HANDLER";
    }
}

