/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.api.exceptions;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import jayeson.lib.delivery.api.exceptions.PipelineException;

public abstract class MessageEncodingException
extends PipelineException {
    public static final ChannelFutureListener FIRE_ROUTER_ENCODE_EXCEPTION_ON_FAILURE = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                if (!(future.cause() instanceof PipelineException)) {
                    RouterMessageEncodingException encodingException = new RouterMessageEncodingException(future.cause());
                    future.channel().pipeline().fireExceptionCaught((Throwable)encodingException);
                } else {
                    future.channel().pipeline().fireExceptionCaught(future.cause());
                }
            }
        }
    };
    public static final ChannelFutureListener FIRE_TRANSPORT_ENCODE_EXCEPTION_ON_FAILURE = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                TransportMessageEncodingException encodingException = new TransportMessageEncodingException(future.cause());
                future.channel().pipeline().fireExceptionCaught((Throwable)encodingException);
            }
        }
    };

    public MessageEncodingException(Throwable cause) {
        super(cause);
    }

    public static class TransportMessageEncodingException
    extends MessageEncodingException {
        public TransportMessageEncodingException(Throwable cause) {
            super(cause);
        }
    }

    public static class RouterMessageEncodingException
    extends MessageEncodingException {
        public RouterMessageEncodingException(Throwable cause) {
            super(cause);
        }
    }
}

