/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.api.messages;

import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;

public class MessageWrapper {
    private Object message;
    private IMessageClass<?> msgCls;
    private IEndPoint endpoint;
    private Map<MetaInformationCode, String> metaInformation;
    private boolean encodeMessage;

    public MessageWrapper(Object msg, IMessageClass<?> msgCls) {
        this.message = msg;
        this.msgCls = msgCls;
        this.metaInformation = null;
        this.encodeMessage = true;
    }

    public Object msg() {
        return this.message;
    }

    public IMessageClass<?> getMessageClass() {
        return this.msgCls;
    }

    public IMessageGroup getMessageGroup() {
        if (this.msgCls != null) {
            return this.msgCls.group();
        }
        return null;
    }

    public IEndPoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(IEndPoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public void setMessageClass(IMessageClass<?> msgCls) {
        this.msgCls = msgCls;
    }

    public Map<MetaInformationCode, String> getMetaInformation() {
        return this.metaInformation;
    }

    public boolean encodeMessage() {
        return this.encodeMessage;
    }

    public void encodeMessage(boolean encodeMessage) {
        this.encodeMessage = encodeMessage;
    }

    public boolean hasMetaInformation() {
        return this.metaInformation != null;
    }

    public boolean hasMetaInformation(MetaInformationCode code) {
        return this.hasMetaInformation() && this.metaInformation.get(code) != null;
    }

    public String getMetaInformation(MetaInformationCode code) {
        if (!this.hasMetaInformation()) {
            return null;
        }
        return this.metaInformation.get(code);
    }

    public void addMetaInformation(MetaInformationCode code, String content) {
        if (!this.hasMetaInformation()) {
            this.metaInformation = new HashMap<MetaInformationCode, String>();
        }
        this.metaInformation.put(code, content);
    }

    public void setMetaInformation(Map<MetaInformationCode, String> metaInfo) {
        this.metaInformation = metaInfo;
    }
}

