/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Map;
import jayeson.lib.delivery.api.CoreComponent;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.TransportRouterMarker;
import jayeson.lib.delivery.api.events.CoreComponentChangedEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.exceptions.MessageEncodingException;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPointMismatchException;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.tasks.ResponseFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPoint
implements IEndPoint {
    private static Logger log = LoggerFactory.getLogger(EndPoint.class);
    private SocketChannel channel;
    private IRouter router;
    private ITransport transport;
    private ChannelFutureListener channelFutureListener;
    private IEPEventDispatcher eventDisaptcher;
    private int pendingWriteTasksCount;
    private int maxPendingWriteTasksAllowed = 2000;

    @Inject
    public EndPoint(@Assisted SocketChannel channel, @Assisted IRouter router, @Assisted ITransport transport) {
        this.channel = channel;
        this.router = router;
        this.transport = transport;
        this.router.setEndPoint(this);
        this.transport.setEndPoint(this);
        this.setupInitialPipeline();
        this.pendingWriteTasksCount = 0;
    }

    private void setupInitialPipeline() {
        TransportRouterMarker trMarker = TransportRouterMarker.getInstance();
        this.channel.pipeline().addLast(trMarker.getName(), (ChannelHandler)trMarker);
        this.transport.attach(this.channel.pipeline());
        this.transport.setEndPoint(this);
        this.router.attach(this.channel.pipeline());
        this.router.setEndPoint(this);
    }

    @Override
    public void send(MessageWrapper mw) {
        this.checkEndPoint(mw);
        this.sendMessage(mw, this.channelFutureListener);
    }

    public void send(MessageWrapper mw, ChannelFutureListener cfListener) {
        this.checkEndPoint(mw);
        this.sendMessage(mw, cfListener);
    }

    private void sendMessage(MessageWrapper mw, ChannelFutureListener cfListener) {
        NettyMessageWrapper nettyMessageWrapper = new NettyMessageWrapper(mw);
        DefaultChannelPromise promise = new DefaultChannelPromise((Channel)this.channel);
        if (cfListener != null) {
            promise.addListener((GenericFutureListener)cfListener);
        }
        promise.addListener((GenericFutureListener)MessageEncodingException.FIRE_ROUTER_ENCODE_EXCEPTION_ON_FAILURE);
        this.controlledWriteAndFlush(nettyMessageWrapper, (ChannelPromise)promise);
    }

    private void controlledWriteAndFlush(NettyMessageWrapper nettyMessageWrapper, ChannelPromise promise) {
        if (this.channel.isWritable()) {
            this.pendingWriteTasksCount = 0;
            this.channel.writeAndFlush((Object)nettyMessageWrapper, promise);
        } else {
            ++this.pendingWriteTasksCount;
            if (this.pendingWriteTasksCount <= this.maxPendingWriteTasksAllowed) {
                this.channel.writeAndFlush((Object)nettyMessageWrapper, promise);
            } else {
                log.warn("Channel not writable, closing remote connection: {} {}", (Object)this.channel.remoteAddress(), (Object)this.pendingWriteTasksCount);
                this.channel.close();
            }
        }
    }

    private void checkEndPoint(MessageWrapper mw) throws EndPointMismatchException {
        if (mw.getEndpoint() != null && mw.getEndpoint() != this) {
            throw new EndPointMismatchException();
        }
    }

    @Override
    public void registerGroupProcessor(IMessageGroup group, IMessageGroupProcessor groupProcessor) {
        Map<IMessageGroup, IMessageGroupProcessor> registeredGroupProcessors = this.router.getRegisteredMessageGroups();
        if (registeredGroupProcessors != null) {
            for (Map.Entry<IMessageGroup, IMessageGroupProcessor> entry : registeredGroupProcessors.entrySet()) {
                if (!entry.getKey().isSameGroup(group) || entry.getValue() != groupProcessor) continue;
                log.warn("GroupProcessor is already registered. Not taking any action");
                return;
            }
        }
        this.router.registerProcessor(group, groupProcessor);
        groupProcessor.onRegistered(this);
    }

    @Override
    public void registerPreParsingHook(IMessageGroup group, IPreParsingHook preParsingHook) {
        Map<IMessageGroup, IPreParsingHook> registeredPreparsingHooks = this.router.getRegisteredPreParsingHooks();
        if (registeredPreparsingHooks != null) {
            for (Map.Entry<IMessageGroup, IPreParsingHook> entry : registeredPreparsingHooks.entrySet()) {
                if (!entry.getKey().isSameGroup(group) || entry.getValue() != preParsingHook) continue;
                log.warn("PreParsingHook is already registered. Not taking any action");
                return;
            }
        }
        this.router.registerPreParsingHook(group, preParsingHook);
        preParsingHook.onRegistered(this);
    }

    @Override
    public void deregisterPreParsingHook(byte groupId) {
        this.router.deregisterPreParsingHook(groupId);
    }

    @Override
    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isActive();
    }

    @Override
    public String getPeerIp() {
        if (this.channel == null) {
            return null;
        }
        InetSocketAddress socketAddress = this.channel.remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        return socketAddress.getHostString();
    }

    @Override
    public int getPeerPort() {
        if (this.channel == null) {
            return -1;
        }
        InetSocketAddress socketAddress = this.channel.remoteAddress();
        if (socketAddress == null) {
            return -1;
        }
        return socketAddress.getPort();
    }

    @Override
    public void close() {
        ChannelFuture future = this.channel.disconnect();
        if (this.channelFutureListener != null) {
            future.addListener((GenericFutureListener)this.channelFutureListener);
        }
    }

    public ChannelFutureListener getChannelFutureListener() {
        return this.channelFutureListener;
    }

    public void setChannelFutureListener(ChannelFutureListener channelFutureListener) {
        this.channelFutureListener = channelFutureListener;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public IEndPoint changeCoreComponent(CoreComponent newComponent) {
        if (newComponent == null) {
            log.error("New component is null. Cannot be injected");
            return null;
        }
        if (newComponent instanceof ITransport) {
            this.replaceComponent(this.transport, newComponent);
            this.transport = (ITransport)newComponent;
        }
        if (newComponent instanceof IRouter) {
            this.replaceComponent(this.router, newComponent);
            Map<IMessageGroup, IMessageGroupProcessor> registeredGroups = this.router.getRegisteredMessageGroups();
            for (IMessageGroup key : registeredGroups.keySet()) {
                ((IRouter)newComponent).registerProcessor(key, registeredGroups.get(key));
            }
            Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks = this.router.getRegisteredPreParsingHooks();
            for (IMessageGroup key : registeredPreParsingHooks.keySet()) {
                ((IRouter)newComponent).registerPreParsingHook(key, registeredPreParsingHooks.get(key));
            }
            this.router = (IRouter)newComponent;
        }
        CoreComponentChangedEvent c = new CoreComponentChangedEvent(this, newComponent);
        c.setEndpoint(this);
        this.eventDisaptcher.dispatchEvent(c);
        log.trace("Pipeline after changing component {}", (Object)this.channel.pipeline().toString());
        return this;
    }

    private void replaceComponent(CoreComponent oldComponent, CoreComponent newComponent) {
        this.channel.flush();
        log.trace("Replacing component {}  with {} for peer {}", new Object[]{oldComponent.getClass(), newComponent.getClass(), this.getIdentifier()});
        oldComponent.detach(this.channel.pipeline());
        newComponent.attach(this.channel.pipeline());
        newComponent.setEndPoint(this);
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventDisaptcher.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDisaptcher.deregisterListener(listener);
    }

    public IEPEventDispatcher getEventDisaptcher() {
        return this.eventDisaptcher;
    }

    @Inject
    public void setEventDisaptcher(IEPEventDispatcher eventDisaptcher) {
        this.eventDisaptcher = eventDisaptcher;
    }

    public void sendMessage(MessageWrapper message, boolean skipMessageClassHandlers) {
        if (skipMessageClassHandlers) {
            message.encodeMessage(false);
        }
        this.sendMessage(message, this.channelFutureListener);
    }

    public ResponseFuture request(MessageWrapper mw, ChannelFutureListener cfListener, long timeOut) throws Exception {
        this.checkEndPoint(mw);
        NettyMessageWrapper nettyMessageWrapper = new NettyMessageWrapper(mw);
        ResponseFuture responseFuture = this.router.storeRequest(nettyMessageWrapper, timeOut);
        DefaultChannelPromise promise = new DefaultChannelPromise((Channel)this.channel);
        if (cfListener != null) {
            promise.addListener((GenericFutureListener)cfListener);
        }
        promise.addListener((GenericFutureListener)MessageEncodingException.FIRE_ROUTER_ENCODE_EXCEPTION_ON_FAILURE);
        this.controlledWriteAndFlush(nettyMessageWrapper, (ChannelPromise)promise);
        return responseFuture;
    }

    public ResponseFuture request(MessageWrapper mw, long timeOut) throws Exception {
        return this.request(mw, null, timeOut);
    }

    @Override
    public void reply(MessageWrapper original, MessageWrapper response) throws Exception {
        MessageWrapper r = this.router.createReply(original, response);
        this.send(r);
    }

    @Override
    public void addHandler(NamedHandler namedHandler) {
        if (this.isHandlerPresent(namedHandler.getName())) {
            log.trace("Replacing handler {} with  {} {}", new Object[]{this.channel.pipeline().get(namedHandler.getName()).getClass(), namedHandler.getName(), namedHandler.getClass()});
            this.channel.pipeline().replace(namedHandler.getName(), namedHandler.getName(), (ChannelHandler)namedHandler);
        } else {
            log.trace("Adding handler {} {}", (Object)namedHandler.getName(), namedHandler.getClass());
            this.channel.pipeline().addLast(namedHandler.getName(), (ChannelHandler)namedHandler);
        }
    }

    @Override
    public void removeHandler(String name) {
        this.channel.flush();
        if (this.isHandlerPresent(name)) {
            log.trace("Removing handler {} {}", (Object)name, this.channel.pipeline().get(name).getClass());
            this.channel.pipeline().remove(name);
        }
    }

    public boolean isHandlerPresent(String name) {
        return this.channel.pipeline().get(name) != null;
    }

    @Override
    public <T> void setState(AttributeKey<T> key, T value) {
        this.channel.attr(key).set(value);
    }

    @Override
    public <T> T getState(AttributeKey<T> key) {
        return (T)this.channel.attr(key).get();
    }
}

