/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.core.EPEventListenerWrapper;
import jayeson.lib.delivery.core.EventMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusBasedEPEventDispatcher
implements IEPEventDispatcher {
    private static Logger log = LoggerFactory.getLogger(EventBusBasedEPEventDispatcher.class);
    private Map<IEndPointListener, EPEventListenerWrapper> listenerMap = new HashMap<IEndPointListener, EPEventListenerWrapper>();
    protected EventBus wrapperPool = new EventBus((SubscriberExceptionHandler)EventMonitor.INSTANCE);

    public EventBusBasedEPEventDispatcher() {
        this.wrapperPool.register((Object)EventMonitor.INSTANCE);
    }

    @Override
    public void registerListener(IEndPointListener listener) {
        EPEventListenerWrapper wrapper = new EPEventListenerWrapper(listener);
        this.wrapperPool.register((Object)wrapper);
        this.listenerMap.put(listener, wrapper);
    }

    @Override
    public void deregisterListener(IEndPointListener listener) {
        if (!this.listenerMap.containsKey(listener)) {
            log.warn("Listener {} is not registered.", (Object)listener);
        } else {
            try {
                this.wrapperPool.unregister((Object)this.listenerMap.get(listener));
            }
            catch (IllegalArgumentException e) {
                log.error("Error while unregistering a listener ", (Throwable)e);
            }
            this.listenerMap.remove(listener);
        }
    }

    @Override
    public void dispatchEvent(EPEvent e) {
        this.wrapperPool.post((Object)e);
    }

    @Override
    public List<IEndPointListener> getAllRegisteredListeners() {
        ArrayList<IEndPointListener> returnList = new ArrayList<IEndPointListener>();
        returnList.addAll(this.listenerMap.keySet());
        return returnList;
    }
}

