/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import jayeson.lib.delivery.api.exceptions.DeliveryExceptionHandler;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.messages.GenericMessageGroup;

@Singleton
@ChannelHandler.Sharable
public class HttpExceptionHandler
extends DeliveryExceptionHandler {
    @Inject
    private GenericMessageGroup group;

    @Override
    public void onException(PipelineException ex) {
        EndPoint ep = (EndPoint)ex.getEndPoint();
        if (ep.getChannel().isActive() && ep.getChannel().isWritable()) {
            ByteBuf buf = ep.getChannel().alloc().buffer();
            String pl = "Error:" + ex.printableString();
            buf.writeBytes(pl.getBytes());
            MessageWrapper mw = new MessageWrapper(buf, this.group.HTTP_RESPONSE);
            ep.send(mw, cf -> ep.close());
        }
    }
}

