/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.http;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.core.http.messages.HttpRequestMessageClass;
import jayeson.lib.delivery.core.http.messages.ObscureMessageGroup;
import jayeson.lib.delivery.core.tcp.BaseInMultiplexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInMultiplexer
extends BaseInMultiplexer
implements NamedHandler {
    public static final String MESSAGE_GROUP = "MessageGroup";
    public static final String MESSAGE_CLASS = "MessageClass";
    private static final Logger log = LoggerFactory.getLogger(HttpInMultiplexer.class);
    @Inject
    ObscureMessageGroup obscureMessageGroup;
    private Map<Byte, MetaInformationCode> codeMap;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NettyMessageWrapper wrappedMsg = new NettyMessageWrapper(msg, null);
        HttpRequest request = (HttpRequest)wrappedMsg.msg();
        String groupInfo = request.headers().get(MESSAGE_GROUP);
        String classInfo = request.headers().get(MESSAGE_CLASS);
        boolean hasCompleteMessageGroupAndClassInformation = false;
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        if (groupInfo == null || classInfo == null) {
            List messageGroupList = (List)decoder.parameters().get(MESSAGE_GROUP);
            List messageClassList = (List)decoder.parameters().get(MESSAGE_CLASS);
            if (messageGroupList != null && !messageGroupList.isEmpty() && messageClassList != null && !messageClassList.isEmpty()) {
                groupInfo = (String)messageGroupList.get(0);
                classInfo = (String)messageClassList.get(0);
            }
        }
        if (groupInfo != null && classInfo != null) {
            IMessageClass<?> messageClass;
            Byte groupByte = new Byte(groupInfo);
            Byte classByte = new Byte(classInfo);
            IMessageGroup messageGroup = this.getGroupFromByte(groupByte);
            if (messageGroup != null && (messageClass = messageGroup.classById(classByte)) != null) {
                wrappedMsg.setMessageClass(messageClass);
                hasCompleteMessageGroupAndClassInformation = true;
            }
        }
        if (!hasCompleteMessageGroupAndClassInformation) {
            wrappedMsg.setMessageClass(this.obscureMessageGroup.getInstanceOf(HttpRequestMessageClass.class));
        }
        this.parseMetaInformation(wrappedMsg, request);
        ctx.fireChannelRead((Object)wrappedMsg);
    }

    @Inject
    private void setMetaInformationCode(Map<Byte, MetaInformationCode> codeMap) {
        this.codeMap = codeMap;
    }

    private void parseMetaInformation(NettyMessageWrapper wrappedMsg, HttpRequest request) {
        HttpHeaders headers = request.headers();
        headers.forEach(header -> {
            String headerName = ((String)header.getKey()).toString();
            String headerValue = ((String)header.getValue()).toString();
            if (headerName.startsWith("X-META-")) {
                byte code = Byte.parseByte(headerName.substring("X-META-".length()));
                wrappedMsg.addMetaInformation(this.codeMap.get(code), headerValue);
            }
        });
        if (!wrappedMsg.hasMetaInformation()) {
            QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
            Map parameters = decoder.parameters();
            parameters.forEach((queryKey, queryValues) -> {
                if (queryKey.startsWith("X-META-")) {
                    byte code = Byte.parseByte(queryKey.substring("X-META-".length()));
                    wrappedMsg.addMetaInformation(this.codeMap.get(code), (String)queryValues.get(0));
                }
            });
        }
    }

    @Override
    public String getName() {
        return "HTTP_INMULTIPLEXER";
    }
}

