/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.MessageCorruptedException;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.core.http.messages.HttpMessageWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOutMultiplexer
extends ChannelOutboundHandlerAdapter
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(HttpOutMultiplexer.class);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        NettyMessageWrapper wrapper = (NettyMessageWrapper)msg;
        Object rawMsg = wrapper.msg();
        HttpResponse responseTobeSent = null;
        if (rawMsg instanceof HttpResponse) {
            responseTobeSent = (HttpResponse)rawMsg;
        } else if (rawMsg instanceof ByteBuf) {
            ByteBuf content = (ByteBuf)rawMsg;
            responseTobeSent = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
            responseTobeSent.headers().set("Content-Type", (Object)"text/plain");
            responseTobeSent.headers().set("Content-Length", (Object)content.readableBytes());
            responseTobeSent.headers().set("Connection", (Object)"keep-alive");
        } else {
            log.error("Error Encoding input data Expecting ByteBuf or HttpResponse");
        }
        if (responseTobeSent != null) {
            byte groupId = wrapper.getMessageGroup().id();
            byte classId = wrapper.getMessageClass().id();
            responseTobeSent.headers().add("MessageGroup", (Object)String.valueOf(groupId));
            responseTobeSent.headers().add("MessageClass", (Object)String.valueOf(classId));
            Map<MetaInformationCode, String> metaInformation = wrapper.getMetaInformation();
            if (metaInformation != null) {
                this.setupMetaInformationsForResponse(responseTobeSent, metaInformation);
            }
            if (wrapper.original() instanceof HttpMessageWrapper) {
                this.setDataToResponse((HttpMessageWrapper)wrapper.original(), responseTobeSent);
            }
            ctx.write((Object)responseTobeSent, promise);
        }
    }

    private void setupMetaInformationsForResponse(HttpResponse responseTobeSent, Map<MetaInformationCode, String> metaInformation) throws MessageCorruptedException {
        for (Map.Entry<MetaInformationCode, String> entry : metaInformation.entrySet()) {
            String key = "X-META-" + entry.getKey().code();
            responseTobeSent.headers().add(key, (Object)entry.getValue());
        }
    }

    private void setDataToResponse(HttpMessageWrapper original, HttpResponse responseTobeSent) {
        original.headers().entrySet().stream().forEach(x -> responseTobeSent.headers().set((String)x.getKey(), x.getValue()));
        if (original.hasStatus()) {
            responseTobeSent.setStatus(HttpResponseStatus.valueOf((int)original.status()));
        }
    }

    @Override
    public String getName() {
        return "HTTP_OUTMULTIPLEXER";
    }
}

