/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.http;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.List;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.core.http.HttpExceptionHandler;
import jayeson.lib.delivery.core.http.HttpInMultiplexer;
import jayeson.lib.delivery.core.http.HttpOutMultiplexer;
import jayeson.lib.delivery.core.http.messages.ObscureMessageGroup;
import jayeson.lib.delivery.core.tcp.AbstractRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRouter
extends AbstractRouter {
    private static Logger log = LoggerFactory.getLogger(HttpRouter.class);
    @Inject
    ObscureMessageGroup group;
    private HttpInMultiplexer httpInMultiplexer;
    private HttpOutMultiplexer httpOutMultiplexer;
    private HttpExceptionHandler exceptionHandler;

    @Override
    public List<NamedHandler> getDefaultHandlers() {
        ArrayList<NamedHandler> returnList = new ArrayList<NamedHandler>();
        returnList.add(this.httpInMultiplexer);
        returnList.add(this.decodeMessageDam);
        returnList.add(this.decodeStatusNotifier);
        returnList.add(this.httpOutMultiplexer);
        returnList.add(this.encodeStatusNotifier);
        returnList.add(this.encodeMessageDam);
        returnList.add(this.exceptionHandler);
        return returnList;
    }

    @Inject
    public void setHttpInMultiplexer(HttpInMultiplexer httpInMultiplexer) {
        this.httpInMultiplexer = httpInMultiplexer;
        httpInMultiplexer.setRegisteredMessageGroups(this.byteVsMessageGroup);
    }

    @Inject
    public void setHttpOutMultiplexer(HttpOutMultiplexer httpOutMultiplexer) {
        this.httpOutMultiplexer = httpOutMultiplexer;
    }

    @Override
    public void detach(ChannelPipeline pipeline) {
        for (NamedHandler c : this.getDefaultHandlers()) {
            log.trace("Removing {}", (Object)c.getName());
            pipeline.remove(c.getName());
        }
        IMessageClass<?> lastEncodedMessageClass = this.encodeMessageDam.getLastEncodedMessageClass();
        IMessageClass<?> lastDecodedMessageClass = this.decodeMessageDam.getLastDecodedMessageClass();
        if (lastEncodedMessageClass != null && this.encodeMessageDam.isLastMessagePassedThroughEncoding()) {
            List<ChannelHandler> existingWriteHandlers = lastEncodedMessageClass.constructor().outboundHandlers(null);
            for (ChannelHandler handler : existingWriteHandlers) {
                pipeline.remove(handler.getClass());
            }
        }
        if (lastDecodedMessageClass != null) {
            List<ChannelHandler> existingReadHandlers = lastDecodedMessageClass.constructor().inboundHandlers(null);
            for (ChannelHandler handler : existingReadHandlers) {
                pipeline.remove(handler.getClass());
            }
        }
    }

    @Inject
    public void setHttpExceptionHandler(HttpExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

