/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.keepalive;

import com.google.inject.Inject;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.keepalive.KeepAliveMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleStateListener
extends ChannelDuplexHandler
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(IdleStateListener.class);
    private IEndPoint endPoint;
    private KeepAliveMessageGroup kaGroup;

    @Inject
    public IdleStateListener(KeepAliveMessageGroup grp) {
        this.kaGroup = grp;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            this.sendKeepAlive(e);
        }
    }

    public void sendKeepAlive(IdleStateEvent evt) {
        MessageWrapper mw = new MessageWrapper("", this.kaGroup.MSG);
        try {
            this.endPoint.send(mw);
            log.trace("EndPoint is in {}. Send keep-alive message to {}", (Object)evt.state(), (Object)this.endPoint.getIdentifier());
        }
        catch (Exception e) {
            log.error("Exception while sending keep-alive to {}", (Object)this.endPoint.getIdentifier(), (Object)e);
        }
    }

    @Override
    public String getName() {
        return "IDLESTATE_LISTENER";
    }

    public IEndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(IEndPoint endPoint) {
        this.endPoint = endPoint;
    }
}

