/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.keepalive;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.keepalive.KeepAliveMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KeepAliveGroupProcessor
implements IMessageGroupProcessor {
    private KeepAliveMessageGroup keepAliveGroup;
    private Object keepAliveDummy;
    private Logger log = LoggerFactory.getLogger(KeepAliveGroupProcessor.class);

    @Inject
    public KeepAliveGroupProcessor(KeepAliveMessageGroup keepAliveGroup) {
        this.keepAliveGroup = keepAliveGroup;
        this.keepAliveDummy = new Object();
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.keepAliveGroup;
    }

    @Override
    public void process(MessageWrapper mw) throws Exception {
        if (mw.getMessageClass() == this.keepAliveGroup.KEEPALIVE_REQUEST) {
            this.log.debug("Received keepalive request from {} and sending response.", (Object)mw.getEndpoint().getIdentifier());
            MessageWrapper responseMw = new MessageWrapper(mw.msg(), this.keepAliveGroup.KEEPALIVE_RESPONSE);
            mw.getEndpoint().reply(mw, responseMw);
        } else {
            this.log.error("Received non keepalive request from {}: {}", (Object)mw.getEndpoint().getIdentifier(), (Object)mw.getMessageClass().id());
        }
    }

    public Map<CompletableFuture<Void>, IEndPoint> sendKeepAlive(Set<IEndPoint> uniqueEndPoints, long timeOut) {
        MessageWrapper mw = new MessageWrapper(this.keepAliveDummy, this.keepAliveGroup.KEEPALIVE_REQUEST);
        HashMap<CompletableFuture<Void>, IEndPoint> futures = new HashMap<CompletableFuture<Void>, IEndPoint>();
        for (IEndPoint endPoint : uniqueEndPoints) {
            try {
                this.log.info("Sending keepalive to {}", (Object)endPoint.getIdentifier());
                CompletionStage currFuture = endPoint.request(mw, timeOut).thenAccept(reply -> this.log.info("Received keepalive reply from: {}", (Object)reply.getEndpoint().getIdentifier()));
                futures.put((CompletableFuture<Void>)currFuture, endPoint);
            }
            catch (Exception exp) {
                this.log.error("Exception sending keepalive to {}: {}", (Object)endPoint.getIdentifier(), (Object)exp);
            }
        }
        return futures;
    }
}

