/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.messages;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCounted;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import jayeson.lib.delivery.core.messages.BaseMessageClass;

public class JSonBaseMessageClass<T>
extends BaseMessageClass<T> {
    private ObjectMapper mapper;
    protected InHandler inH;
    protected OutHandler outH;

    public JSonBaseMessageClass(IMessageGroup group, Class<T> instanceClass, byte id, ObjectMapper mapper) {
        super(instanceClass, group, id);
        this.mapper = mapper;
        this.inH = new InHandler();
        this.outH = new OutHandler();
    }

    @Override
    public List<ChannelHandler> inboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.inH});
    }

    @Override
    public List<ChannelHandler> outboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.outH});
    }

    @ChannelHandler.Sharable
    private class OutHandler
    extends ChannelOutboundHandlerAdapter {
        private OutHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            byte[] arr = JSonBaseMessageClass.this.mapper.writeValueAsBytes(msg);
            ByteBuf buf = ctx.alloc().buffer(arr.length);
            buf.writeBytes(arr);
            ctx.write((Object)buf, promise);
        }
    }

    @ChannelHandler.Sharable
    private class InHandler
    extends ChannelInboundHandlerAdapter {
        private InHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            byte[] jsonString = null;
            if (msg instanceof String) {
                jsonString = ((String)msg).getBytes();
            } else if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                jsonString = new byte[buf.readableBytes()];
                buf.readBytes(jsonString);
                DeliveryCoreUtility.release((ReferenceCounted)buf);
            }
            try {
                Object parsed = JSonBaseMessageClass.this.mapper.readValue(jsonString, JSonBaseMessageClass.this.instanceClass());
                ctx.fireChannelRead(parsed);
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
                ctx.fireChannelReadComplete();
            }
        }
    }
}

