/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.server;

import com.google.inject.Inject;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.IServer;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.ServerConfig;
import jayeson.lib.delivery.api.events.EPConnectedEvent;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.core.CoreComponentFactory;
import jayeson.lib.delivery.core.keepalive.KeepAliveConstants;
import jayeson.lib.delivery.core.keepalive.KeepAliveGroupPreParsingHook;
import jayeson.lib.delivery.core.keepalive.KeepAliveGroupProcessor;
import jayeson.lib.delivery.core.keepalive.KeepAliveMessageGroup;
import jayeson.lib.delivery.core.server.NettyBaseServer;
import jayeson.lib.delivery.core.server.ServerEndPointMonitor;
import jayeson.lib.delivery.core.server.ServerEndPointMonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer
extends NettyBaseServer
implements IServer,
IEndPointListener {
    Logger log = LoggerFactory.getLogger(DefaultServer.class);
    private ServerEndPointMonitorFactory serverEPMF;
    private ITransport transport;
    private IRouter router;
    protected CoreComponentFactory ccFactory;
    private Map<IMessageGroup, IMessageGroupProcessor> registeredMessageGroups;
    private Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks;
    private IEPEventDispatcher eventDispatcher;
    boolean keepAlive;

    @Inject
    public DefaultServer(ServerConfig configuration, ServerEndPointMonitorFactory serverEPMF) {
        super(configuration);
        this.serverEPMF = serverEPMF;
        this.registeredMessageGroups = new HashMap<IMessageGroup, IMessageGroupProcessor>();
        this.registeredPreParsingHooks = new HashMap<IMessageGroup, IPreParsingHook>();
        this.keepAlive = configuration.isIdleStateKeepAlive();
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        IRouter router = this.ccFactory.createRouter((Channel)ch);
        ITransport transport = this.ccFactory.createTransport((Channel)ch);
        this.setupChannel(ch, router, transport);
    }

    protected void setupChannel(SocketChannel ch, IRouter router, ITransport transport) {
        ChannelPipeline channelPipeline = ch.pipeline();
        ServerEndPointMonitor serverEndPointMonitor = this.serverEPMF.create(this, router, transport);
        serverEndPointMonitor.setListener(this);
        channelPipeline.addLast(new ChannelHandler[]{serverEndPointMonitor});
        this.getChannelGroup().add((Channel)ch);
        this.log.info("Number of active connections {}", (Object)this.getChannelGroup().size());
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventDispatcher.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDispatcher.deregisterListener(listener);
    }

    @Override
    public IServer start() {
        try {
            super.startNettyServer();
            return this;
        }
        catch (Exception e) {
            this.log.error("Internal Error occurred while starting Netty Base server", (Throwable)e);
            return null;
        }
    }

    @Override
    public IServer registerMessageGroup(IMessageGroup group, IMessageGroupProcessor messageGroupProcessor) {
        this.registeredMessageGroups.put(group, messageGroupProcessor);
        return this;
    }

    @Override
    public IServer setInitialTransport(ITransport transport) {
        this.transport = transport;
        return this;
    }

    @Override
    public IServer setInitialRouter(IRouter router) {
        this.router = router;
        return this;
    }

    @Override
    public void onEvent(EPEvent event) {
        if (event instanceof EPConnectedEvent) {
            this.setupKeepAlive(event.getEndpoint());
        }
        if (event instanceof EPDisconnectedEvent) {
            this.log.info("Number of active connections {}", (Object)this.getChannelGroup().size());
        }
        this.eventDispatcher.dispatchEvent(event);
    }

    private void setupKeepAlive(IEndPoint ep) {
        ep.setState(KeepAliveConstants.ATTR_KEEP_ALIVE, this.keepAlive);
        Integer i = (int)this.config.getKeepAliveInterval();
        ep.setState(KeepAliveConstants.ATTR_KEEP_ALIVE_INTERVAL, i);
    }

    @Override
    public void stop() {
        try {
            super.stopNettyServer();
        }
        catch (InterruptedException e) {
            this.log.error("Error while stopping Netty base server", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public Map<IMessageGroup, IMessageGroupProcessor> getRegisteredMessageGroups() {
        HashMap<IMessageGroup, IMessageGroupProcessor> returnMap = new HashMap<IMessageGroup, IMessageGroupProcessor>();
        for (IMessageGroup key : this.registeredMessageGroups.keySet()) {
            returnMap.put(key, this.registeredMessageGroups.get(key));
        }
        return returnMap;
    }

    public IEPEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Inject
    public void setEventDispatcher(IEPEventDispatcher epEventDispatcher) {
        this.eventDispatcher = epEventDispatcher;
    }

    @Override
    public IServer registerPreParsingHook(IMessageGroup group, IPreParsingHook preParsingHook) {
        this.registeredPreParsingHooks.put(group, preParsingHook);
        return this;
    }

    @Override
    public Map<IMessageGroup, IPreParsingHook> getRegisteredPreParsingHooks() {
        HashMap<IMessageGroup, IPreParsingHook> returnMap = new HashMap<IMessageGroup, IPreParsingHook>();
        for (IMessageGroup key : this.registeredPreParsingHooks.keySet()) {
            returnMap.put(key, this.registeredPreParsingHooks.get(key));
        }
        return returnMap;
    }

    @Inject
    private void _kaPreParsingHook(KeepAliveMessageGroup grp, KeepAliveGroupPreParsingHook hook) {
        this.registerPreParsingHook(grp, hook);
    }

    @Inject
    private void registerKeepAliveGroupProcessor(KeepAliveMessageGroup kaGroup, KeepAliveGroupProcessor kaProcessor) {
        this.registerMessageGroup(kaGroup, kaProcessor);
    }

    @Inject
    public void setCCFactory(CoreComponentFactory ccFactory) {
        this.ccFactory = ccFactory;
    }

    @Override
    public IServer setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public ServerConfig configuration() {
        return this.config;
    }
}

