/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import jayeson.lib.delivery.core.IMessageBuffer;
import jayeson.lib.delivery.core.NettyMessageWrapper;
import jayeson.lib.delivery.core.metainfo.MessageIdCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeMessageDam
extends ChannelInboundHandlerAdapter
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(DecodeMessageDam.class);
    private IMessageBuffer<NettyMessageWrapper> messagesInBuffer;
    private IMessageBuffer<NettyMessageWrapper> messagesInPipeline;
    private Map<Byte, IPreParsingHook> preParsingHooks;
    private IMessageClass<?> lastDecodedMessageClass;
    private IRouter router;
    private MessageIdCode msgIdCode;

    public IMessageClass<?> getLastDecodedMessageClass() {
        return this.lastDecodedMessageClass;
    }

    public void setLastDecodedMessageClass(IMessageClass<?> lastDecodedMessageClass) {
        this.lastDecodedMessageClass = lastDecodedMessageClass;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        IPreParsingHook preParsingHook;
        NettyMessageWrapper nettyMessageWrapper = (NettyMessageWrapper)msg;
        nettyMessageWrapper.setChannelHandlerContext(ctx);
        if (this.preParsingHooks != null && (preParsingHook = this.preParsingHooks.get(nettyMessageWrapper.getMessageGroup().id())) != null) {
            nettyMessageWrapper.setEndpoint(this.router.getEndPoint());
            boolean parseEnabled = preParsingHook.processUnParsedMessage(nettyMessageWrapper);
            if (!(parseEnabled || nettyMessageWrapper.hasMetaInformation() && nettyMessageWrapper.getMetaInformation(this.msgIdCode) != null)) {
                ctx.fireChannelReadComplete();
                if (nettyMessageWrapper.msg() instanceof ReferenceCounted) {
                    DeliveryCoreUtility.release((ReferenceCounted)nettyMessageWrapper.msg());
                } else {
                    log.warn("Raw message is not reference counted?? {}", nettyMessageWrapper.msg());
                }
                return;
            }
        }
        if (this.messagesInBuffer.hasMessage()) {
            this.messagesInBuffer.pushMessage(nettyMessageWrapper);
            return;
        }
        if (this.lastDecodedMessageClass != null) {
            if (this.lastDecodedMessageClass.isSameFormat(nettyMessageWrapper.getMessageClass())) {
                this.sendMessageToPipeline(nettyMessageWrapper);
            } else {
                this.updatePipeline(nettyMessageWrapper);
                this.sendMessageToPipeline(nettyMessageWrapper);
            }
        } else {
            this.updatePipeline(nettyMessageWrapper);
            this.sendMessageToPipeline(nettyMessageWrapper);
        }
    }

    private void sendMessageToPipeline(NettyMessageWrapper nettyMessageWrapper) {
        this.messagesInPipeline.pushMessage(nettyMessageWrapper);
        nettyMessageWrapper.getChannelHandlerContext().fireChannelRead(nettyMessageWrapper.msg());
    }

    private void updatePipeline(NettyMessageWrapper nettyMessageWrapper) {
        ChannelPipeline pipeline = nettyMessageWrapper.getChannelHandlerContext().pipeline();
        if (this.lastDecodedMessageClass != null) {
            List<ChannelHandler> existingReadHandlers = this.lastDecodedMessageClass.constructor().inboundHandlers(nettyMessageWrapper.getChannelHandlerContext().channel());
            for (ChannelHandler handler : existingReadHandlers) {
                pipeline.remove(handler.getClass());
            }
        }
        List<ChannelHandler> newReadHandlers = nettyMessageWrapper.getMessageClass().constructor().inboundHandlers(nettyMessageWrapper.getChannelHandlerContext().channel());
        for (ChannelHandler channleHandler : newReadHandlers) {
            pipeline.addBefore("DECODE_STATUS_NOTIFIER", channleHandler.toString(), channleHandler);
        }
        this.lastDecodedMessageClass = nettyMessageWrapper.getMessageClass();
    }

    @Override
    public String getName() {
        return "DECODE_MESSAGE_DAM";
    }

    public NettyMessageWrapper signalDecodeFinished() {
        NettyMessageWrapper nextMessage;
        NettyMessageWrapper returnObject = this.messagesInPipeline.popMessage();
        if (this.messagesInPipeline.getMessageCount() == 0 && (nextMessage = this.messagesInBuffer.popMessage()) != null) {
            this.updatePipeline(nextMessage);
            this.sendMessageToPipeline(nextMessage);
        }
        return returnObject;
    }

    @Inject
    private void setMessagesInBuffer(IMessageBuffer<NettyMessageWrapper> nettyMessageBuffer) {
        this.messagesInBuffer = nettyMessageBuffer;
    }

    @Inject
    private void setMessagesInpipeline(IMessageBuffer<NettyMessageWrapper> encodeMessages) {
        this.messagesInPipeline = encodeMessages;
    }

    @Inject
    private void setMessageIdCode(MessageIdCode code) {
        this.msgIdCode = code;
    }

    public Map<Byte, IPreParsingHook> getPreParsingHooks() {
        return this.preParsingHooks;
    }

    public void setPreParsingHooks(Map<Byte, IPreParsingHook> preParsingHooks) {
        this.preParsingHooks = preParsingHooks;
    }

    public IRouter getRouter() {
        return this.router;
    }

    public void setRouter(IRouter router) {
        this.router = router;
    }
}

