/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.MessageDecodingException;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import jayeson.lib.delivery.core.tcp.AbstractRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeStatusNotifier
extends ChannelInboundHandlerAdapter
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(DecodeStatusNotifier.class);
    private AbstractRouter router;

    public void setRouter(AbstractRouter router) {
        this.router = router;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.router.onDecodeFinished(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        PipelineException exception = null;
        exception = !(cause instanceof PipelineException) ? new MessageDecodingException.RouterMessageDecodingException(cause) : (PipelineException)cause;
        if (this.router.onException(exception)) {
            ctx.fireExceptionCaught((Throwable)exception);
        }
    }

    @Override
    public String getName() {
        return "DECODE_STATUS_NOTIFIER";
    }
}

