/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.List;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.core.IMessageBuffer;
import jayeson.lib.delivery.core.NettyMessageWrapper;

public class EncodeMessageDam
extends ChannelOutboundHandlerAdapter
implements NamedHandler {
    private IMessageBuffer<NettyMessageWrapper> messagesInBuffer;
    private IMessageBuffer<NettyMessageWrapper> messagesInPipeline;
    private IMessageClass<?> lastEncodedMessageClass;
    private boolean isLastMessagePassedThroughEncoding;

    public IMessageClass<?> getLastEncodedMessageClass() {
        return this.lastEncodedMessageClass;
    }

    public void setLastEncodedMessageClass(IMessageClass<?> lastEncodedMessageClass) {
        this.lastEncodedMessageClass = lastEncodedMessageClass;
    }

    public boolean isLastMessagePassedThroughEncoding() {
        return this.isLastMessagePassedThroughEncoding;
    }

    public void setLastMessagePassedThroughEncoding(boolean isLastMessagePassedThroughEncoding) {
        this.isLastMessagePassedThroughEncoding = isLastMessagePassedThroughEncoding;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        NettyMessageWrapper nettyMessageWrapper = (NettyMessageWrapper)msg;
        nettyMessageWrapper.setChannelHandlerContext(ctx);
        nettyMessageWrapper.setPromise(promise);
        if (this.messagesInBuffer.hasMessage()) {
            this.messagesInBuffer.pushMessage(nettyMessageWrapper);
        } else if (this.lastEncodedMessageClass != null) {
            if (!(this.messagesInPipeline.getMessageCount() <= 0 || this.lastEncodedMessageClass.isSameFormat(nettyMessageWrapper.getMessageClass()) && this.isLastMessagePassedThroughEncoding == nettyMessageWrapper.encodeMessage())) {
                this.messagesInBuffer.pushMessage(nettyMessageWrapper);
            } else {
                this.updatePipeline(nettyMessageWrapper);
                this.sendMessageToPipeline(nettyMessageWrapper);
            }
        } else {
            this.updatePipeline(nettyMessageWrapper);
            this.sendMessageToPipeline(nettyMessageWrapper);
        }
    }

    @Override
    public String getName() {
        return "ENCODE_MESSAGE_DAM";
    }

    private void updatePipeline(NettyMessageWrapper nettyMessageWrapper) {
        ChannelPipeline pipeline = nettyMessageWrapper.getChannelHandlerContext().pipeline();
        if (this.lastEncodedMessageClass != null && this.isLastMessagePassedThroughEncoding) {
            List<ChannelHandler> existingWriteHandlers = this.lastEncodedMessageClass.constructor().outboundHandlers(nettyMessageWrapper.getChannelHandlerContext().channel());
            for (ChannelHandler handler : existingWriteHandlers) {
                pipeline.remove(handler.getClass());
            }
        }
        if (nettyMessageWrapper.encodeMessage()) {
            List<ChannelHandler> newWriteHandlers = nettyMessageWrapper.getMessageClass().constructor().outboundHandlers(nettyMessageWrapper.getChannelHandlerContext().channel());
            for (ChannelHandler channleHandler : newWriteHandlers) {
                pipeline.addAfter("ENCODE_STATUS_NOTIFIER", channleHandler.toString(), channleHandler);
            }
            this.isLastMessagePassedThroughEncoding = true;
        } else {
            this.isLastMessagePassedThroughEncoding = false;
        }
        this.lastEncodedMessageClass = nettyMessageWrapper.getMessageClass();
    }

    private void sendMessageToPipeline(NettyMessageWrapper nettyMessageWrapper) {
        this.messagesInPipeline.pushMessage(nettyMessageWrapper);
        nettyMessageWrapper.getChannelHandlerContext().write(nettyMessageWrapper.msg(), nettyMessageWrapper.getPromise());
    }

    public NettyMessageWrapper signalEncodeFinished() {
        NettyMessageWrapper nextMessage;
        NettyMessageWrapper returnObject = this.messagesInPipeline.popMessage();
        if (this.messagesInPipeline.getMessageCount() == 0 && (nextMessage = this.messagesInBuffer.popMessage()) != null) {
            this.updatePipeline(nextMessage);
            this.sendMessageToPipeline(nextMessage);
        }
        return returnObject;
    }

    @Inject
    private void setMessagesInBuffer(IMessageBuffer<NettyMessageWrapper> nettyMessageBuffer) {
        this.messagesInBuffer = nettyMessageBuffer;
    }

    @Inject
    private void setMessagesInpipeline(IMessageBuffer<NettyMessageWrapper> encodeMessages) {
        this.messagesInPipeline = encodeMessages;
    }
}

