/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCounted;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.core.DeliveryCoreUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufToWebSocketFrameEncoderDecoder
extends ChannelDuplexHandler
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(ByteBufToWebSocketFrameEncoderDecoder.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof CloseWebSocketFrame) {
            log.trace("Close Frame received {}", (Object)ctx.channel().toString());
            DeliveryCoreUtility.release((ReferenceCounted)frame);
        } else {
            ByteBuf content = frame.content();
            ctx.fireChannelRead((Object)content);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            log.error("Error Encoding input data to Frame. Expecing ByteBuf");
        } else {
            ByteBuf bindaryData = (ByteBuf)msg;
            BinaryWebSocketFrame b = new BinaryWebSocketFrame(bindaryData);
            ctx.write((Object)b, promise);
        }
    }

    @Override
    public String getName() {
        return "BYTEBUF_TO_WESOCKET_FRAME_ENCODER_DECODER";
    }
}

