/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth;

import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.module.auth.AuthServiceConfig;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;

class AuthContentWaiter
extends CompletableFuture<Boolean>
implements Runnable {
    private ScheduledExecutorService ses;
    private long timeout;
    private AuthContent content;
    private IEndPoint endPoint;

    @Inject
    public AuthContentWaiter(@Assisted IEndPoint endpoint, AuthServiceConfig config, @Named(value="CommonSES") ScheduledExecutorService ses) {
        this.ses = ses;
        this.timeout = config.getAuthMsgTimeout();
        this.endPoint = endpoint;
    }

    @Override
    public synchronized void run() {
        if (!this.isDone()) {
            this.complete(false);
        }
    }

    public synchronized void receive(AuthContent content) {
        if (!this.isDone()) {
            this.content = content;
            this.complete(true);
        }
    }

    public AuthContent getContent() {
        return this.content;
    }

    public IEndPoint getEndPoint() {
        return this.endPoint;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void waitAuth() {
        this.ses.schedule(this, this.timeout, TimeUnit.MILLISECONDS);
    }

    static interface F {
        public AuthContentWaiter create(IEndPoint var1);
    }
}

