/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessManagerFactory;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.delivery.api.CoreComponent;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointEventSource;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.http.messages.HttpMessageWrapper;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.delivery.core.websocket.WebSocketRouter;
import jayeson.lib.delivery.core.websocket.WebSocketTransport;
import jayeson.lib.delivery.module.auth.AuthEntryConfig;
import jayeson.lib.delivery.module.auth.AuthGroupProcessor;
import jayeson.lib.delivery.module.auth.AuthRequestBuilder;
import jayeson.lib.delivery.module.auth.AuthServiceConfig;
import jayeson.lib.delivery.module.auth.IAuthService;
import jayeson.lib.delivery.module.auth.event.AuthFailed;
import jayeson.lib.delivery.module.auth.event.AuthSuccessful;
import jayeson.lib.delivery.module.auth.event.TicketExpired;
import jayeson.lib.delivery.module.auth.messages.AuthGroup;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;
import jayeson.lib.delivery.module.auth.messages.beans.GeneralResponse;
import jayeson.lib.delivery.module.auth.messages.beans.WSAuthContent;
import jayeson.lib.session.AsyncSessionAccessor;
import jayeson.utility.crypto.Crypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthService
implements IEndPointEventSource,
IEndPointListener,
IAuthService,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    public static final String EPF_AR = "access_request";
    private IEPEventDispatcher _ed;
    private AuthGroup _mg;
    AuthServiceConfig sharedConfig;
    Provider<WebSocketRouter> wrp;
    Provider<WebSocketTransport> wtp;
    public static final String EPF_ACCESS_REQUEST = "access";
    public static final String EPF_USERNAME = "username";
    public static final String EPF_SCOPE = "scope";
    private IMessageGroupProcessor processor;
    private Map<Long, AuthWrapper> eps = new ConcurrentHashMap<Long, AuthWrapper>(30, 0.75f, 2);
    private AccessManagerFactory amFactory;
    private ScheduledExecutorService ses;
    private Crypto crypto;

    @Inject
    public AuthService(AuthServiceConfig config, AuthGroup group, AccessManagerFactory factory, @Named(value="CommonSES") ScheduledExecutorService ses) {
        this._mg = group;
        this.sharedConfig = config;
        this.ses = ses;
        this.amFactory = factory;
        this.ses.submit(this);
    }

    @Inject
    public void setEventDispatcher(IEPEventDispatcher dispatcher) {
        this._ed = dispatcher;
    }

    @Inject
    public void setProcessor(AuthGroupProcessor processor) {
        this.processor = processor;
        processor.setAuthService(this);
    }

    @Inject
    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    @Inject
    public void setWRP(Provider<WebSocketRouter> wrp) {
        this.wrp = wrp;
    }

    @Inject
    public void setWTP(Provider<WebSocketTransport> wtp) {
        this.wtp = wtp;
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this._ed.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this._ed.deregisterListener(listener);
    }

    @Override
    public void onEvent(EPEvent event) {
        if (event instanceof EPDisconnectedEvent) {
            ServerEndPoint endPoint = (ServerEndPoint)event.getEndpoint();
            log.info("ServerEndPoint with Id {} disconnected and removed from AuthService", (Object)endPoint.getId());
            this.eps.remove(endPoint.getId());
        }
    }

    @Override
    public IMessageGroupProcessor getProcessor() {
        return this.processor;
    }

    private void authFailed(IEndPoint endPoint, String reply) {
        AuthFailed event = new AuthFailed(endPoint);
        EndPoint ep = (EndPoint)endPoint;
        GeneralResponse gr = new GeneralResponse();
        gr.setMessage(reply);
        gr.setStatus(1);
        ep.send(new MessageWrapper(gr, this._mg.GENERAL_RESPONSE), x -> this._ed.dispatchEvent(event));
    }

    void authFailed(IEndPoint endPoint) {
        this.authFailed(endPoint, "Authentication Failed!!!");
    }

    void authSuccessful(IEndPoint endPoint, AuthContent content, AccessRequest ar) {
        AuthSuccessful event = new AuthSuccessful(endPoint, content, content.getFeedScope(), ar.getUsername());
        EndPoint ep = (EndPoint)endPoint;
        GeneralResponse gr = new GeneralResponse();
        gr.setMessage("Authentication successful!!!");
        gr.setStatus(0);
        MessageWrapper wrapper = null;
        wrapper = content instanceof WSAuthContent && ((WSAuthContent)content).isWsUpgrade() ? new HttpMessageWrapper("", this._mg.STRING).status(101).withHeader("Upgrade", "websocket").withHeader("Connection", "Upgrade").withHeader("Sec-WebSocket-Accept", ((WSAuthContent)content).getWebsocketAccept()) : new MessageWrapper(gr, this._mg.GENERAL_RESPONSE);
        ep.send(wrapper, x -> {
            if (content instanceof WSAuthContent) {
                ep.changeCoreComponent((CoreComponent)this.wtp.get());
                ep.changeCoreComponent((CoreComponent)this.wrp.get());
            }
            this._ed.dispatchEvent(event);
        });
    }

    void authenticate(IEndPoint endPoint, AuthContent content) throws ExecutionException, InterruptedException {
        AccessRequest ar;
        AuthEntryConfig config = this.sharedConfig.getAuthenticatorConfigs().get(content.getFeedScope());
        log.debug("Starting auth with scope [" + content.getFeedScope() + "], [" + config + "]");
        if (config == null) {
            this.authFailed(endPoint, "Token is from an unknown scope");
            log.debug("Unable to auth " + endPoint.getIdentifier() + ": Token is from an unknown scope");
            return;
        }
        AuthRequestBuilder builder = new AuthRequestBuilder(this.crypto, config, content);
        AccessManager am = this.amFactory.getAM(config.getAccessManagerName());
        try {
            ar = builder.build(am);
        }
        catch (Exception e) {
            log.error("Exception while building access request!", (Throwable)e);
            this.authFailed(endPoint, "Internal error! Access request corrupted.");
            log.debug("Unable to auth " + endPoint.getIdentifier() + ": Internal error! Access request corrupted.");
            return;
        }
        if (ar != null && ((Boolean)am.isLoggedIn(ar).toCompletableFuture().get()).booleanValue()) {
            AsyncSessionAccessor sa = (AsyncSessionAccessor)am.getLoginSession(ar).toCompletableFuture().get();
            if (sa == null) {
                this.authFailed(endPoint, "Internal error! Cannot obtain session.");
                log.debug("Unable to auth " + endPoint.getIdentifier() + ": Internal error! Cannot obtain session.");
                return;
            }
            CompletionStage ticketFuture = sa.read(String.format(config.getTicketPattern(), content.getClientId()));
            ticketFuture.whenComplete((storedTicket, error) -> {
                if (error != null) {
                    this.authFailed(endPoint, "Unable to retrieve ticket from session store: " + error);
                    log.debug("Unable to auth " + endPoint.getIdentifier() + ": Unable to retrieve ticket from session store");
                } else if (storedTicket != null && storedTicket.equals(content.getTicket())) {
                    ServerEndPoint serverSocket = (ServerEndPoint)endPoint;
                    serverSocket.setData(EPF_ACCESS_REQUEST, ar);
                    serverSocket.setData(EPF_USERNAME, ar.getUsername());
                    serverSocket.setData(EPF_SCOPE, content.getFeedScope());
                    this.authSuccessful(endPoint, content, ar);
                    this.eps.put(((ServerEndPoint)endPoint).getId(), new AuthWrapper((ServerEndPoint)endPoint, content, sa));
                } else {
                    this.authFailed(endPoint, "Ticket not matched!");
                    log.debug("Unable to auth " + endPoint.getPeerIp() + ":" + endPoint.getPeerPort() + ": Ticket not matched! StoredTicket [" + storedTicket + "], " + content);
                }
            });
        } else {
            this.authFailed(endPoint);
            log.debug("Unable to auth " + endPoint.getPeerIp() + ":" + endPoint.getPeerPort() + ": User not logged in.");
        }
    }

    public boolean isAuthenticated(IEndPoint ep) {
        if (!(ep instanceof ServerEndPoint)) {
            return false;
        }
        ServerEndPoint e = (ServerEndPoint)ep;
        return this.eps.get(e.getId()) != null;
    }

    public void renewTicket(ServerEndPoint ep, String clientId, String newTicket) {
        CompletionStage<GeneralResponse> gr;
        AuthWrapper w = this.eps.get(ep.getId());
        if (w == null) {
            log.error("AuthWrapper not found for {}: {}", (Object)ep.getId(), (Object)ep.getIdentifier());
            return;
        }
        AuthEntryConfig config = this.sharedConfig.getAuthenticatorConfigs().get(w.c.getFeedScope());
        if (config == null) {
            return;
        }
        if (newTicket.equals(w.c.getTicket())) {
            gr = CompletableFuture.completedFuture(new GeneralResponse("Ticket Renew Failed! New ticket duplicate with old ticket!", 1));
        } else {
            CompletionStage ticketFuture = w.sa.read(String.format(config.getTicketPattern(), clientId));
            gr = ticketFuture.thenApply(storedTicket -> {
                if (storedTicket == null || !storedTicket.equals(newTicket)) {
                    log.debug("Ticket renew failed for {}, redisTicket: {}, receivedTicket: {}", new Object[]{clientId, storedTicket, newTicket});
                    return new GeneralResponse("Ticket Renew Failed! New ticket isn't found in user session!", 1);
                }
                w.c.setTicket(newTicket);
                return new GeneralResponse("Ticket Renewed Successfully!", 0);
            });
        }
        gr.thenAccept(response -> w.ep.send(new MessageWrapper(response, this._mg.GENERAL_RESPONSE)));
    }

    @Override
    public void run() {
        List<CompletableFuture> notificationFutures = this.eps.values().stream().map(this::validateEndpoint).collect(Collectors.toList());
        CompletableFuture[] arr = new CompletableFuture[]{};
        arr = notificationFutures.toArray(arr);
        CompletableFuture.allOf(arr).thenAccept(x -> this.ses.schedule(this, this.sharedConfig.getTicketCheckingInterval(), TimeUnit.MILLISECONDS));
    }

    CompletableFuture<AuthWrapper> validateEndpoint(AuthWrapper endpointInfo) {
        return this.checkTicket(endpointInfo).thenCompose(wrapper -> {
            if (this.isEndpointExpired((AuthWrapper)wrapper)) {
                this.eps.remove(wrapper.ep.getId());
                return this.notifyTicketExpiry((AuthWrapper)wrapper);
            }
            return CompletableFuture.completedFuture(endpointInfo);
        });
    }

    CompletableFuture<AuthWrapper> notifyTicketExpiry(AuthWrapper endpointInfo) {
        log.info("Client with id {} has ticket {} expired", (Object)endpointInfo.c.getClientId(), (Object)endpointInfo.c.getTicket());
        CompletableFuture<AuthWrapper> msgFuture = new CompletableFuture<AuthWrapper>();
        endpointInfo.ep.send(new MessageWrapper(new GeneralResponse("Ticket Expired!", 2), this._mg.GENERAL_RESPONSE), x -> {
            this._ed.dispatchEvent(new TicketExpired(endpointInfo.ep, endpointInfo.c.getTicket()));
            msgFuture.complete(endpointInfo);
        });
        return msgFuture;
    }

    CompletableFuture<AuthWrapper> checkTicket(AuthWrapper endpointInfo) {
        AuthEntryConfig config = this.sharedConfig.getAuthenticatorConfigs().get(endpointInfo.c.getFeedScope());
        if (config == null) {
            ++endpointInfo.numInvalid;
            return CompletableFuture.completedFuture(endpointInfo);
        }
        String clientId = endpointInfo.c.getClientId();
        AsyncSessionAccessor sa = endpointInfo.sa;
        CompletableFuture ticketFuture = (CompletableFuture)sa.read(String.format(config.getTicketPattern(), clientId));
        return ticketFuture.thenApply(storedTicket -> {
            endpointInfo.numInvalid = storedTicket == null || !storedTicket.equals(endpointInfo.c.getTicket()) ? ++endpointInfo.numInvalid : 0;
            endpointInfo.prevTicket = storedTicket;
            return endpointInfo;
        });
    }

    boolean isEndpointExpired(AuthWrapper endpointInfo) {
        return endpointInfo.prevTicket == null || endpointInfo.numInvalid >= 2;
    }

    private static class AuthWrapper {
        public ServerEndPoint ep;
        public AuthContent c;
        public AsyncSessionAccessor sa;
        public String prevTicket;
        public int numInvalid;

        public AuthWrapper(ServerEndPoint ep, AuthContent content, AsyncSessionAccessor sa) {
            this.ep = ep;
            this.c = content;
            this.sa = sa;
            this.numInvalid = 0;
        }
    }
}

