/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher;

import com.google.common.eventbus.Subscribe;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.module.auth.event.AuthEvent;
import jayeson.lib.delivery.module.auth.event.AuthFailed;
import jayeson.lib.delivery.module.auth.event.AuthSuccessful;
import jayeson.lib.delivery.module.auth.event.SessionInvalid;
import jayeson.lib.delivery.module.auth.event.TicketExpired;
import jayeson.lib.delivery.module.publisher.IEventReactor;
import jayeson.lib.delivery.module.publisher.IPublisher;
import jayeson.lib.delivery.module.streamregistry.IStreamRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthentcationEventReactor
implements IEventReactor {
    private static Logger log = LoggerFactory.getLogger(AuthentcationEventReactor.class);
    private IPublisher publisher;

    public AuthentcationEventReactor(IPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public IPublisher getPublisher() {
        return this.publisher;
    }

    @Subscribe
    public void eventLogic(AuthEvent event) {
        IEndPoint ep = event.getEndpoint();
        if (event instanceof AuthSuccessful) {
            AuthSuccessful as = (AuthSuccessful)event;
            log.info("Received AuthSuccessful event for user {} scope {} endpoint {}.Attaching StreamRegistry", new Object[]{as.getUsername(), as.getScope(), ep.getIdentifier()});
            IStreamRegistry streamRegistry = this.publisher.getStreamRegistry();
            IMessageGroupProcessor gp = streamRegistry.getProcessor();
            ep.registerGroupProcessor(gp.messageGroup(), gp);
            this.publisher.dispatchEvent(event);
        }
        if (event instanceof AuthFailed || event instanceof SessionInvalid || event instanceof TicketExpired) {
            log.info("Received AuthenticationFailed Event {} for EndPoint {}. Disconnecting", event.getClass(), (Object)ep.getIdentifier());
            ep.close();
        }
    }
}

