/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.IServer;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.module.auth.IAuthService;
import jayeson.lib.delivery.module.auth.event.AuthEvent;
import jayeson.lib.delivery.module.publisher.AuthentcationEventReactor;
import jayeson.lib.delivery.module.publisher.IPublisher;
import jayeson.lib.delivery.module.publisher.PublisherConfig;
import jayeson.lib.delivery.module.publisher.PublisherEventReactor;
import jayeson.lib.delivery.module.publisher.StreamRegistryEventReactor;
import jayeson.lib.delivery.module.streamregistry.IStreamRegistry;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistryEvent;
import jayeson.service.delivery.IProcessingEngine;

public class Publisher
implements IPublisher {
    @Inject
    private IAuthService authenticationService;
    @Inject
    private IStreamRegistry streamRegistry;
    @Inject
    private IServer server;
    @Inject
    private PublisherConfig publisherConfig;
    private EventBus _eb;
    private Set<IProcessingEngine> processingEngines;
    private PublisherEventReactor publisherEventReactor;
    private StreamRegistryEventReactor streamRegistryEventReactor;
    private AuthentcationEventReactor authenticationEventReactor;
    Set<IEndPointListener> eventListeners;

    @Inject
    public Publisher(EventBus _eb) {
        this._eb = _eb;
        this.publisherEventReactor = new PublisherEventReactor(this);
        _eb.register((Object)this.publisherEventReactor);
        this.streamRegistryEventReactor = new StreamRegistryEventReactor(this);
        _eb.register((Object)this.streamRegistryEventReactor);
        this.authenticationEventReactor = new AuthentcationEventReactor(this);
        _eb.register((Object)this.authenticationEventReactor);
        this.eventListeners = new HashSet<IEndPointListener>();
    }

    @Override
    public void startPublishing() {
        this.server.attachListener(this);
        this.streamRegistry.attachListener(this);
        this.attachListener(this.streamRegistry);
        this.authenticationService.attachListener(this);
        this.attachListener(this.authenticationService);
        for (IProcessingEngine p : this.processingEngines) {
            p.attachListener(this);
            this.attachListener(p);
        }
        IServer startResult = this.server.start();
        if (startResult != null) {
            for (IProcessingEngine p : this.processingEngines) {
                p.setConnected(true);
            }
        }
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void onEvent(EPEvent event) {
        this._eb.post((Object)event);
    }

    @Override
    public void dispatchEvent(EPEvent epEvent) {
        if (epEvent instanceof StreamRegistryEvent) {
            for (IEndPointListener listener : this.eventListeners) {
                listener.onEvent(epEvent);
            }
        } else if (epEvent instanceof AuthEvent) {
            for (IProcessingEngine p : this.processingEngines) {
                p.onEvent(epEvent);
            }
            this.streamRegistry.onEvent(epEvent);
        } else if (epEvent instanceof EPDisconnectedEvent && this.streamRegistry.getUserName(epEvent.getEndpoint()) != null) {
            for (IProcessingEngine p : this.processingEngines) {
                p.onEvent(epEvent);
            }
            this.streamRegistry.onEvent(epEvent);
            this.authenticationService.onEvent(epEvent);
        }
    }

    @Override
    public IStreamRegistry getStreamRegistry() {
        return this.streamRegistry;
    }

    @Override
    public IAuthService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public IProcessingEngine getProcessingEngine(byte messageGroup) {
        IProcessingEngine returnEngine = null;
        for (IProcessingEngine processingEngine : this.processingEngines) {
            if (processingEngine.getMessageGroup().id() != messageGroup) continue;
            returnEngine = processingEngine;
            break;
        }
        return returnEngine;
    }

    public Set<IProcessingEngine> getProcessingEngines() {
        return this.processingEngines;
    }

    @Override
    public void stopPublishing() {
        this.server.stop();
    }

    @Override
    public void setProcessingEngines(Set<IProcessingEngine> processingEngines) {
        this.processingEngines = processingEngines;
    }

    public PublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }

    public void setPublisherConfig(PublisherConfig publisherConfig) {
        this.publisherConfig = publisherConfig;
    }
}

