/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher;

import com.google.common.eventbus.Subscribe;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.module.publisher.IEventReactor;
import jayeson.lib.delivery.module.publisher.IPublisher;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistrationEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistryEvent;
import jayeson.service.delivery.IOutProcessor;
import jayeson.service.delivery.IProcessingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRegistryEventReactor
implements IEventReactor {
    private static Logger log = LoggerFactory.getLogger(StreamRegistryEventReactor.class);
    private IPublisher publisher;

    public StreamRegistryEventReactor(IPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public IPublisher getPublisher() {
        return this.publisher;
    }

    @Subscribe
    public void eventLogic(StreamRegistryEvent event) {
        IEndPoint ep = event.getEndpoint();
        if (event instanceof StreamRegistrationEvent) {
            StreamRegistrationEvent sre = (StreamRegistrationEvent)event;
            IProcessingEngine processingEngine = this.publisher.getProcessingEngine(sre.getMessageGroup());
            if (processingEngine == null) {
                log.warn("There is No Processing Engine in Producer for Group {}", (Object)sre.getMessageGroup());
                return;
            }
            if (processingEngine.getOutProcessor() == null) {
                log.warn("There is No OutProcessor in Processing Engine for Group {}", (Object)sre.getMessageGroup());
                return;
            }
            log.trace("Attaching RelayProcessor of Group {} to endpoint {}", (Object)sre.getMessageGroup(), (Object)ep.getIdentifier());
            IOutProcessor gp = processingEngine.getOutProcessor();
            ep.registerGroupProcessor(gp.messageGroup(), gp);
            this.publisher.dispatchEvent(event);
        } else {
            this.publisher.dispatchEvent(event);
        }
    }
}

