/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher.server;

import com.google.inject.Inject;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Set;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.IServer;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.core.server.DefaultServer;
import jayeson.lib.delivery.core.server.ServerEndPointMonitorFactory;
import jayeson.lib.delivery.module.publisher.NamedCoreComponentFactory;
import jayeson.lib.delivery.module.publisher.PublisherConfig;
import jayeson.lib.delivery.module.publisher.TransportMode;
import jayeson.lib.delivery.module.publisher.server.MultiPortServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPortBoundServer
extends DefaultServer {
    private static Logger log = LoggerFactory.getLogger(MultiPortBoundServer.class);
    private NamedCoreComponentFactory namedCCProvider;
    private PublisherConfig publisherConfig;
    private MultiPortServerConfig multiPortServerConfig;

    @Inject
    public MultiPortBoundServer(MultiPortServerConfig configuration, ServerEndPointMonitorFactory serverEPMF) {
        super(configuration, serverEPMF);
        this.multiPortServerConfig = configuration;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        log.info("New connection for {} {}", (Object)ch.remoteAddress().getHostString(), (Object)ch.remoteAddress().getPort());
        ITransport transport = null;
        IRouter router = null;
        if (ch.localAddress().getPort() == this.multiPortServerConfig.getTcpPort()) {
            router = this.namedCCProvider.createTCPRouter((Channel)ch);
            transport = this.namedCCProvider.createTCPTransport((Channel)ch);
        } else if (ch.localAddress().getPort() == this.multiPortServerConfig.getSslPort()) {
            router = this.namedCCProvider.createSSLRouter((Channel)ch);
            transport = this.namedCCProvider.createSSLTransport((Channel)ch);
        } else {
            log.error("FATAL : Port is is neither TCP or SSL? {}. Fallback to default binding", (Object)ch.localAddress().getPort());
            router = this.ccFactory.createRouter((Channel)ch);
            transport = this.ccFactory.createTransport((Channel)ch);
        }
        this.setupChannel(ch, router, transport);
    }

    @Override
    public IServer start() {
        try {
            this.startNettyServer();
            return this;
        }
        catch (Exception e) {
            log.error("Internal Error occurred while starting Netty Base server", (Throwable)e);
            this.stop();
            return null;
        }
    }

    @Override
    protected void startNettyServer() throws InterruptedException {
        if (this.channelGroup != null && !this.channelGroup.isEmpty()) {
            log.warn("Server already started and has active EndPoints. Restarting");
            this.stopNettyServer();
        }
        ServerBootstrap serverBootStrap = new ServerBootstrap();
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(1);
        this.channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ((ServerBootstrap)((ServerBootstrap)serverBootStrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        Set<TransportMode> supportedTransport = this.publisherConfig.getSupportedTransport();
        ChannelFuture tcpBindFuture = null;
        ChannelFuture sslBindFuture = null;
        for (TransportMode tMode : supportedTransport) {
            if (tMode.isSsl()) continue;
            log.info("Binding TCP transport to port {}", (Object)this.multiPortServerConfig.getTcpPort());
            tcpBindFuture = serverBootStrap.bind(this.multiPortServerConfig.getTcpPort());
            break;
        }
        for (TransportMode tMode : supportedTransport) {
            if (!tMode.isSsl()) continue;
            log.info("Binding SSL transport to port {}", (Object)this.multiPortServerConfig.getSslPort());
            sslBindFuture = serverBootStrap.bind(this.multiPortServerConfig.getSslPort());
            break;
        }
        log.info("Waiting for server to connect....");
        if (tcpBindFuture != null) {
            tcpBindFuture.sync();
        }
        if (sslBindFuture != null) {
            sslBindFuture.sync();
        }
    }

    public NamedCoreComponentFactory getNamedCCProvider() {
        return this.namedCCProvider;
    }

    @Inject
    public void setNamedCCProvider(NamedCoreComponentFactory namedCCProvider) {
        this.namedCCProvider = namedCCProvider;
    }

    public PublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }

    @Inject
    public void setPublisherConfig(PublisherConfig publisherConfig) {
        this.publisherConfig = publisherConfig;
    }
}

