/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.streamregistry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.module.streamregistry.EndPointState;
import jayeson.lib.delivery.module.streamregistry.GroupStream;
import jayeson.lib.streamfinder.User;
import jayeson.lib.streamfinder.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileCache {
    private UserRepository userRepository;
    private static Logger log = LoggerFactory.getLogger(ProfileCache.class);
    Map<IEndPoint, EndPointState> endPointStateMap;
    List<GroupStream> blockedStreams;

    @Inject
    public ProfileCache(UserRepository userRepository) {
        this.clear();
        this.userRepository = userRepository;
    }

    public void saveUserState(String scope, String userName, IEndPoint endpoint) {
        if (this.endPointExists(endpoint)) {
            throw new RuntimeException("EndPoint already exists in profile cache.");
        }
        this.endPointStateMap.put(endpoint, new EndPointState(scope, userName, endpoint));
    }

    public void dropUserState(IEndPoint endpoint) {
        EndPointState info = this.endPointStateMap.remove(endpoint);
        if (info != null) {
            log.info("Removed EndPointState for user {} for EndPoint {}", (Object)info.getUserId(), (Object)endpoint.getIdentifier());
        }
    }

    public String getUserid(IEndPoint ep) {
        EndPointState epState = this.getEndPointState(ep);
        if (epState == null) {
            return null;
        }
        return epState.getUserId();
    }

    public String getScopeOf(IEndPoint ep) {
        EndPointState epState = this.getEndPointState(ep);
        if (epState == null) {
            return null;
        }
        return epState.getScope();
    }

    public boolean isRegistered(IEndPoint ep, Byte messageGroup, String stream) {
        EndPointState epState = this.getEndPointState(ep);
        if (epState == null) {
            return false;
        }
        return epState.isRegistered(messageGroup, stream);
    }

    public void annotateStreamAsConsumed(IEndPoint ep, Byte group, Set<String> consumptionAllowedStreamStrings) {
        if (!this.endPointExists(ep)) {
            throw new RuntimeException("EndPoint does not exist in profile cache.");
        }
        EndPointState epState = this.getEndPointState(ep);
        for (String stream : consumptionAllowedStreamStrings) {
            epState.annotateStreamAsConsumed(group, stream);
        }
    }

    public User findFeedUserByName(String scope, String userId) {
        return this.userRepository.findFeedUserByName(scope, userId);
    }

    public void annotateStreamAsRegistered(IEndPoint endpoint, Byte messageGroup, Set<String> successfullyRegisteredStreams) {
        if (!this.endPointExists(endpoint)) {
            throw new RuntimeException("EndPoint does not exist in profile cache.");
        }
        EndPointState epState = this.getEndPointState(endpoint);
        for (String stream : successfullyRegisteredStreams) {
            epState.annotateStreamAsRegistered(messageGroup, stream);
        }
    }

    public void annotateStreamAsDeregistered(IEndPoint endpoint, Byte messageGroup, Set<String> registeredStreams) {
        if (!this.endPointExists(endpoint)) {
            throw new RuntimeException("EndPoint does not exist in profile cache. " + endpoint.getIdentifier());
        }
        EndPointState epState = this.getEndPointState(endpoint);
        for (String stream : registeredStreams) {
            epState.annotateStreamAsDeRegistered(messageGroup, stream);
        }
    }

    public Set<String> getConsumingStreams(IEndPoint ep, Byte group) {
        EndPointState epState = this.getEndPointState(ep);
        if (epState == null) {
            return null;
        }
        return epState.getConsumingStreams(group);
    }

    public Set<IEndPoint> getConsumingEndPoints(Byte messageGroup, String stream) {
        HashSet<IEndPoint> endpoints = new HashSet<IEndPoint>();
        GroupStream query = new GroupStream(messageGroup, stream);
        for (IEndPoint ep : this.endPointStateMap.keySet()) {
            EndPointState epState = this.endPointStateMap.get(ep);
            List<GroupStream> allGS = epState.getConsumingStreams();
            if (!allGS.contains(query)) continue;
            endpoints.add(ep);
        }
        return endpoints;
    }

    private boolean endPointExists(IEndPoint ep) {
        return this.endPointStateMap.containsKey(ep);
    }

    private EndPointState getEndPointState(IEndPoint ep) {
        return this.endPointStateMap.get(ep);
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    void clear() {
        this.endPointStateMap = new HashMap<IEndPoint, EndPointState>();
        this.blockedStreams = new ArrayList<GroupStream>();
    }

    boolean isStreamBlocked(GroupStream gs) {
        return this.blockedStreams.contains(gs);
    }

    void blockStream(GroupStream gs, long timeout, ScheduledExecutorService ex) {
        if (!this.blockedStreams.contains(gs)) {
            this.blockedStreams.add(gs);
        }
        if (timeout != -1L) {
            ex.schedule(() -> this.unblockStream(gs), timeout, TimeUnit.MILLISECONDS);
        }
    }

    void unblockStream(GroupStream gs) {
        this.blockedStreams.remove(gs);
    }
}

