/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Optional;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamCopy
implements IPreParsingHook {
    static final Logger log = LoggerFactory.getLogger(UpstreamCopy.class);
    final IMessageGroup group;
    final String stream;
    IEndPoint upstreamSocket;

    public UpstreamCopy(ISubscriber subscriber, IMessageGroup group, String stream, IEndPoint firstSocket) {
        this.group = group;
        this.stream = stream;
        this.upstreamSocket = firstSocket;
        subscriber.attachListener(this::handleUpstreamSocket);
    }

    void handleUpstreamSocket(EPEvent event) {
        ConsumptionErrorEvent stopEvent;
        Optional<StreamId> source;
        if (event instanceof ConsumptionStartEvent) {
            ConsumptionStartEvent startEvent = (ConsumptionStartEvent)event;
            Optional<StreamId> source2 = startEvent.getStreams().stream().filter(src -> src.group.byteValue() == this.group.id() && src.stream.equals(this.stream)).findFirst();
            if (source2.isPresent()) {
                this.upstreamSocket = startEvent.getEndpoint();
            }
        } else if (event instanceof ConsumptionErrorEvent && (source = (stopEvent = (ConsumptionErrorEvent)event).getStreams().stream().filter(src -> src.group.byteValue() == this.group.id() && src.stream.equals(this.stream)).findFirst()).isPresent()) {
            this.upstreamSocket = null;
        }
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.group;
    }

    @Override
    public boolean processUnParsedMessage(MessageWrapper mw) {
        EndPoint upstreamSock = (EndPoint)this.getUpstreamSocket();
        if (upstreamSock == null) {
            return false;
        }
        ByteBuf buf = (ByteBuf)mw.msg();
        byte[] rawData = new byte[buf.readableBytes()];
        buf.readBytes(rawData);
        ByteBuf bufNew = upstreamSock.getChannel().alloc().buffer();
        bufNew.writeBytes(rawData);
        MessageWrapper mwNew = new MessageWrapper(bufNew, mw.getMessageClass());
        mwNew.setMetaInformation(mw.getMetaInformation());
        mwNew.encodeMessage(false);
        try {
            upstreamSock.send(mwNew);
        }
        catch (Exception e) {
            log.error("Unable to send message to " + upstreamSock + ". " + e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
        }
        return false;
    }

    IEndPoint getUpstreamSocket() {
        return this.upstreamSocket;
    }
}

