/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import jayeson.utility.JacksonConfigFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonConfig {
    private String fileName;
    private Object configBean;
    private Class<?> beanClass;
    private boolean ignoreUnknownProperty;
    private static Logger logger = LoggerFactory.getLogger(JacksonConfig.class);
    private JacksonConfigFormat configFormat;
    private ObjectMapper mapper;

    public static <T> T readConfig(String defaultFileName, String systemVar, Class<T> resultClass, JacksonConfigFormat format) {
        T result = null;
        String fileName = null;
        if (systemVar != null) {
            fileName = System.getProperty(systemVar);
        }
        if (fileName == null) {
            fileName = defaultFileName;
        }
        File f = new File(fileName);
        InputStream s = null;
        try {
            if (!f.exists()) {
                logger.trace("Searching {} in class path!", (Object)fileName);
                URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
                if (url == null) {
                    logger.info("Cannot find configuration file {} in class path!", (Object)fileName);
                    return result;
                }
                s = url.openStream();
                logger.trace(fileName);
            } else {
                s = new FileInputStream(f);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open input stream!", e);
        }
        JacksonConfig jc = new JacksonConfig(null, resultClass, format);
        result = resultClass.cast(jc.readConfig(s, resultClass));
        return result;
    }

    public JacksonConfig(String file, Class<?> c) {
        this(file, c, JacksonConfigFormat.XML);
    }

    public JacksonConfig(String file, Class<?> c, JacksonConfigFormat format) {
        this.setFileName(file);
        this.setConfigFormat(format);
        if (file != null && c != null) {
            this.configBean = this.readConfig(this.fileName, c);
        }
    }

    public JacksonConfig(JacksonConfigFormat format) {
        this(null, null, format);
    }

    public JacksonConfig() {
        this.setConfigFormat(JacksonConfigFormat.XML);
    }

    public Object readConfig(InputStream is, Class<?> c) {
        if (this.isIgnoreUnknownProperty()) {
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        try {
            return this.mapper.readValue(is, c);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Cannot parse the configuration file.", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Mapping exception while parsing configuration file", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurs. Does the file exist?", e);
        }
    }

    public Object readConfig(String fileName, Class<?> c) {
        try {
            return this.readConfig(new FileInputStream(new File(fileName)), c);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to find the file " + fileName, e);
        }
    }

    public Object readConfigString(String configString, Class<?> c) {
        if (this.isIgnoreUnknownProperty()) {
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        try {
            return this.mapper.readValue(configString, c);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Cannot parse the configuration string.", e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Mapping exception while parsing configuration string.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurs.", e);
        }
    }

    public void saveConfig(boolean prettyPrint) {
        try {
            File destFile = new File(this.fileName);
            if (destFile.getParentFile() != null && !destFile.exists()) {
                destFile.getParentFile().mkdirs();
            }
            if (!prettyPrint) {
                this.mapper.writeValue(destFile, this.configBean);
            } else {
                JsonGenerator jgen = this.mapper.getFactory().createGenerator((Writer)new PrintWriter(destFile));
                PrettyPrinter pp = this.getPrettyPrinter();
                jgen.setPrettyPrinter(pp);
                this.mapper.writeValue(jgen, this.configBean);
            }
        }
        catch (IOException e) {
            logger.error("Exception while writing config file", (Throwable)e);
        }
    }

    private PrettyPrinter getPrettyPrinter() {
        switch (this.configFormat) {
            case XML: {
                return new DefaultXmlPrettyPrinter();
            }
            case JSON: {
                return new DefaultPrettyPrinter();
            }
        }
        return null;
    }

    public void saveConfig(String fileName, Object value, boolean prettyPrint) {
        this.setFileName(fileName);
        this.setConfigBean(value);
        this.saveConfig(prettyPrint);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isIgnoreUnknownProperty() {
        return this.ignoreUnknownProperty;
    }

    public void setIgnoreUnknownProperty(boolean ignoreUnknownProperty) {
        this.ignoreUnknownProperty = ignoreUnknownProperty;
    }

    public Object getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(Object obj) {
        this.configBean = obj;
        this.setBeanClass(obj.getClass());
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public JacksonConfigFormat getConfigFormat() {
        return this.configFormat;
    }

    public void setConfigFormat(JacksonConfigFormat configFormat) {
        this.configFormat = configFormat;
        switch (this.configFormat) {
            case XML: {
                this.mapper = new XmlMapper();
                return;
            }
            case JSON: {
                this.mapper = new ObjectMapper();
                return;
            }
        }
    }
}

