/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.bet;

import java.math.BigDecimal;
import jayeson.utility.bet.datastructure.BetStatus;
import jayeson.utility.bet.datastructure.LBType;
import jayeson.utility.bet.datastructure.PivotBias;
import jayeson.utility.bet.datastructure.ResolvedBetInfo;
import jayeson.utility.bet.datastructure.TargetType;
import jayeson.utility.bet.datastructure.Utility;

public class BetUtility {
    public static ResolvedBetInfo resolveBet(Integer ftHostGoals, Integer ftGuestGoals, Integer htHostGoals, Integer htGuestGoals, Integer currentHostGoals, Integer currentGuestGoals, Float serverPivot, TargetType targetType, PivotBias pivotBias, Double betStake, Double betOdd, LBType lbType) {
        int htNonFavGoals;
        int htFavGoals;
        int ftNonFavGoals;
        int ftFavGoals;
        ResolvedBetInfo ResolvedBetInfoResult = new ResolvedBetInfo();
        if (ftHostGoals == null || ftGuestGoals == null || htHostGoals == null || htGuestGoals == null || currentHostGoals == null || currentGuestGoals == null || serverPivot == null || betStake == null || betOdd == null) {
            return null;
        }
        float pivotValue = Math.abs(Utility.computePivotValueFromString(String.valueOf(serverPivot)));
        int totalFTGoals = ftHostGoals + ftGuestGoals;
        int totalHTGoals = htHostGoals + htGuestGoals;
        if (pivotBias == PivotBias.GUEST) {
            ftFavGoals = ftGuestGoals - currentGuestGoals;
            ftNonFavGoals = ftHostGoals - currentHostGoals;
            htFavGoals = htGuestGoals - currentGuestGoals;
            htNonFavGoals = htHostGoals - currentHostGoals;
        } else {
            ftFavGoals = ftHostGoals - currentHostGoals;
            ftNonFavGoals = ftGuestGoals - currentGuestGoals;
            htFavGoals = htHostGoals - currentHostGoals;
            htNonFavGoals = htGuestGoals - currentGuestGoals;
        }
        if (!serverPivot.equals(Float.valueOf(0.0f))) {
            switch (targetType) {
                case HOME_HT: {
                    targetType = pivotBias.equals((Object)PivotBias.HOST) ? TargetType.GIVE_HT : TargetType.TAKE_HT;
                    break;
                }
                case HOME_FT: {
                    targetType = pivotBias.equals((Object)PivotBias.HOST) ? TargetType.GIVE_FT : TargetType.TAKE_FT;
                    break;
                }
                case AWAY_HT: {
                    targetType = pivotBias.equals((Object)PivotBias.HOST) ? TargetType.TAKE_HT : TargetType.GIVE_HT;
                    break;
                }
                case AWAY_FT: {
                    targetType = pivotBias.equals((Object)PivotBias.HOST) ? TargetType.TAKE_FT : TargetType.GIVE_FT;
                }
            }
        }
        switch (targetType) {
            case OVER_FT: {
                float pivotValueDiff = (float)totalFTGoals - pivotValue;
                if ((double)pivotValueDiff >= 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (pivotValueDiff > 0.0f && (double)pivotValueDiff < 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (pivotValueDiff == 0.0f) {
                    BetUtility.setDrawBetInfo(ResolvedBetInfoResult);
                    break;
                }
                if (pivotValueDiff < 0.0f && (double)pivotValueDiff > -0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinHalfBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossHalfBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (!((double)pivotValueDiff <= -0.5)) break;
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case UNDER_FT: {
                float pivotValueDiff = (float)totalFTGoals - pivotValue;
                if ((double)pivotValueDiff >= 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (pivotValueDiff > 0.0f && (double)pivotValueDiff < 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinHalfBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossHalfBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (pivotValueDiff == 0.0f) {
                    BetUtility.setDrawBetInfo(ResolvedBetInfoResult);
                    break;
                }
                if (pivotValueDiff < 0.0f && (double)pivotValueDiff > -0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (!((double)pivotValueDiff <= -0.5)) break;
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                break;
            }
            case OVER_HT: {
                float pivotValueDiff = (float)totalHTGoals - pivotValue;
                if ((double)pivotValueDiff >= 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (pivotValueDiff > 0.0f && (double)pivotValueDiff < 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (pivotValueDiff == 0.0f) {
                    BetUtility.setDrawBetInfo(ResolvedBetInfoResult);
                    break;
                }
                if (pivotValueDiff < 0.0f && (double)pivotValueDiff > -0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinHalfBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossHalfBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (!((double)pivotValueDiff <= -0.5)) break;
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case UNDER_HT: {
                float pivotValueDiff = (float)totalHTGoals - pivotValue;
                if ((double)pivotValueDiff >= 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (pivotValueDiff > 0.0f && (double)pivotValueDiff < 0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayWinHalfBetInfo(ResolvedBetInfoResult, betStake);
                        break;
                    }
                    BetUtility.setLossHalfBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                if (pivotValueDiff == 0.0f) {
                    BetUtility.setDrawBetInfo(ResolvedBetInfoResult);
                    break;
                }
                if (pivotValueDiff < 0.0f && (double)pivotValueDiff > -0.5) {
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (!((double)pivotValueDiff <= -0.5)) break;
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                break;
            }
            case ONE_FT: {
                if (ftHostGoals > ftGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case TWO_FT: {
                if (ftHostGoals < ftGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case DRAW_FT: {
                if (ftHostGoals == ftGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case ONE_HT: {
                if (htHostGoals > htGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case TWO_HT: {
                if (htHostGoals < htGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case DRAW_HT: {
                if (htHostGoals == htGuestGoals) {
                    betOdd = betOdd - 1.0;
                    if (LBType.LAY.equals((Object)lbType)) {
                        BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                        break;
                    }
                    BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
                    break;
                }
                if (LBType.LAY.equals((Object)lbType)) {
                    BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
                    break;
                }
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
                break;
            }
            case GIVE_FT: {
                float goalDiff = ftFavGoals - ftNonFavGoals;
                float pivotValueDiff = goalDiff - pivotValue;
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case TAKE_FT: {
                float pivotValueDiff = (float)ftNonFavGoals - ((float)ftFavGoals - pivotValue);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case GIVE_HT: {
                float goalDiff = htFavGoals - htNonFavGoals;
                float pivotValueDiff = goalDiff - pivotValue;
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case TAKE_HT: {
                float pivotValueDiff = (float)htNonFavGoals - ((float)htFavGoals - pivotValue);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case HOME_FT: {
                if (!serverPivot.equals(Float.valueOf(0.0f))) break;
                float pivotValueDiff = ftHostGoals - currentHostGoals - (ftGuestGoals - currentGuestGoals);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case AWAY_FT: {
                if (!serverPivot.equals(Float.valueOf(0.0f))) break;
                float pivotValueDiff = ftGuestGoals - currentGuestGoals - (ftHostGoals - currentHostGoals);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case HOME_HT: {
                if (!serverPivot.equals(Float.valueOf(0.0f))) break;
                float pivotValueDiff = htHostGoals - currentHostGoals - (htGuestGoals - currentGuestGoals);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
            case AWAY_HT: {
                if (!serverPivot.equals(Float.valueOf(0.0f))) break;
                float pivotValueDiff = htGuestGoals - currentGuestGoals - (htHostGoals - currentHostGoals);
                BetUtility.mapPivotValueDiffToResult(pivotValueDiff, ResolvedBetInfoResult, betStake, betOdd, lbType);
                break;
            }
        }
        return ResolvedBetInfoResult;
    }

    private static void mapPivotValueDiffToResult(float pivotValueDiff, ResolvedBetInfo ResolvedBetInfoResult, Double betStake, Double betOdd, LBType lbType) {
        if ((double)pivotValueDiff >= 0.5) {
            if (LBType.LAY.equals((Object)lbType)) {
                BetUtility.setLayLossBetInfo(ResolvedBetInfoResult, betStake, betOdd);
            } else {
                BetUtility.setWinBetInfo(ResolvedBetInfoResult, betStake, betOdd);
            }
        } else if (pivotValueDiff > 0.0f && (double)pivotValueDiff < 0.5) {
            if (LBType.LAY.equals((Object)lbType)) {
                BetUtility.setLayLossHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
            } else {
                BetUtility.setWinHalfBetInfo(ResolvedBetInfoResult, betStake, betOdd);
            }
        } else if (pivotValueDiff == 0.0f) {
            BetUtility.setDrawBetInfo(ResolvedBetInfoResult);
        } else if (pivotValueDiff < 0.0f && (double)pivotValueDiff > -0.5) {
            if (LBType.LAY.equals((Object)lbType)) {
                BetUtility.setLayWinHalfBetInfo(ResolvedBetInfoResult, betStake);
            } else {
                BetUtility.setLossHalfBetInfo(ResolvedBetInfoResult, betStake);
            }
        } else if ((double)pivotValueDiff <= -0.5) {
            if (LBType.LAY.equals((Object)lbType)) {
                BetUtility.setLayWinBetInfo(ResolvedBetInfoResult, betStake);
            } else {
                BetUtility.setLossBetInfo(ResolvedBetInfoResult, betStake);
            }
        }
    }

    private static void setWinBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake, Double betOdd) {
        resolvedBetInfo.setStatus(BetStatus.WIN);
        resolvedBetInfo.setReturnAmount(new BigDecimal(betStake * betOdd));
    }

    private static void setLossBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake) {
        resolvedBetInfo.setStatus(BetStatus.LOSS);
        resolvedBetInfo.setReturnAmount(new BigDecimal(-betStake.doubleValue()));
    }

    private static void setDrawBetInfo(ResolvedBetInfo resolvedBetInfo) {
        resolvedBetInfo.setStatus(BetStatus.DRAW);
        resolvedBetInfo.setReturnAmount(new BigDecimal(0));
    }

    private static void setWinHalfBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake, Double betOdd) {
        resolvedBetInfo.setStatus(BetStatus.WIN);
        resolvedBetInfo.setReturnAmount(new BigDecimal(betStake * betOdd / 2.0));
    }

    private static void setLossHalfBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake) {
        resolvedBetInfo.setStatus(BetStatus.LOSS);
        resolvedBetInfo.setReturnAmount(new BigDecimal(-betStake.doubleValue() / 2.0));
    }

    private static void setLayWinBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake) {
        resolvedBetInfo.setStatus(BetStatus.WIN);
        resolvedBetInfo.setReturnAmount(new BigDecimal(betStake));
    }

    private static void setLayLossBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake, Double betOdd) {
        resolvedBetInfo.setStatus(BetStatus.LOSS);
        resolvedBetInfo.setReturnAmount(new BigDecimal(-betStake.doubleValue() * betOdd));
    }

    private static void setLayWinHalfBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake) {
        resolvedBetInfo.setStatus(BetStatus.WIN);
        resolvedBetInfo.setReturnAmount(new BigDecimal(betStake / 2.0));
    }

    private static void setLayLossHalfBetInfo(ResolvedBetInfo resolvedBetInfo, Double betStake, Double betOdd) {
        resolvedBetInfo.setStatus(BetStatus.LOSS);
        resolvedBetInfo.setReturnAmount(new BigDecimal(-betStake.doubleValue() * betOdd / 2.0));
    }
}

