/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.bet.datastructure;

import java.util.TreeMap;
import jayeson.utility.bet.datastructure.PivotType;
import jayeson.utility.bet.datastructure.TimeType;

public enum TargetType {
    OVER_FT(0, "OVER FT", PivotType.TOTAL, TimeType.FULL_TIME),
    UNDER_FT(1, "UNDER FT", PivotType.TOTAL, TimeType.FULL_TIME),
    GIVE_FT(2, "GIVE FT", PivotType.HDP, TimeType.FULL_TIME),
    TAKE_FT(3, "TAKE FT", PivotType.HDP, TimeType.FULL_TIME),
    ONE_FT(4, "ONE FT", PivotType.ONE_TWO, TimeType.FULL_TIME),
    TWO_FT(5, "TWO FT", PivotType.ONE_TWO, TimeType.FULL_TIME),
    DRAW_FT(6, "DRAW FT", PivotType.ONE_TWO, TimeType.FULL_TIME),
    OVER_HT(7, "OVER HT", PivotType.TOTAL, TimeType.HALF_TIME),
    UNDER_HT(8, "UNDER HT", PivotType.TOTAL, TimeType.HALF_TIME),
    GIVE_HT(9, "GIVE HT", PivotType.HDP, TimeType.HALF_TIME),
    TAKE_HT(10, "TAKE HT", PivotType.HDP, TimeType.HALF_TIME),
    ONE_HT(11, "ONE HT", PivotType.ONE_TWO, TimeType.HALF_TIME),
    TWO_HT(12, "TWO HT", PivotType.ONE_TWO, TimeType.HALF_TIME),
    DRAW_HT(13, "DRAW HT", PivotType.ONE_TWO, TimeType.HALF_TIME),
    HOME_FT(14, "HOME FT", PivotType.HDP, TimeType.FULL_TIME),
    AWAY_FT(15, "AWAY FT", PivotType.HDP, TimeType.FULL_TIME),
    HOME_HT(16, "HOME HT", PivotType.HDP, TimeType.HALF_TIME),
    AWAY_HT(17, "AWAY HT", PivotType.HDP, TimeType.HALF_TIME);

    private int _value;
    private String _display;
    private PivotType _pivotType;
    private TimeType _timeType;
    private static final TreeMap<Integer, TargetType> _map;

    private TargetType(int value, String display, PivotType pivotType, TimeType timeType) {
        this._value = value;
        this._display = display;
        this._pivotType = pivotType;
        this._timeType = timeType;
    }

    public int value() {
        return this._value;
    }

    public String dispText() {
        return this._display;
    }

    public String display() {
        return this._display;
    }

    public PivotType pivotType() {
        return this._pivotType;
    }

    public TimeType eventMinorCategory() {
        return this._timeType;
    }

    public static int getNumOfValues() {
        return _map.size();
    }

    public static String getDispTextFromInt(int value) {
        return TargetType.fromInt(value).dispText();
    }

    public static TargetType fromInt(int value) {
        return _map.get(value);
    }

    static {
        _map = new TreeMap();
        for (TargetType targetType : TargetType.values()) {
            _map.put(new Integer(targetType.value()), targetType);
        }
    }
}

