/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jayeson.utility.concurrent.RetryListener;

public abstract class RetriableTask<T extends Comparable<T>>
implements Callable<T> {
    private AtomicInteger numRetries;
    private int retryInterval;
    private boolean randomizingInterval = false;
    private int randomzingRangeLower;
    private int randomzingRangeUpper;
    private T expected;
    private ExecutorService es;
    private Future<T> cf;
    private boolean started;
    private volatile boolean done;
    private volatile boolean cancelled;
    private RetryListener retryListener;
    private int totalRetries;
    private volatile T lastResult;

    public RetriableTask(int numRetries, int retryInterval, T expected, ExecutorService es) {
        this.totalRetries = numRetries;
        this.numRetries = new AtomicInteger(numRetries);
        this.retryInterval = retryInterval;
        this.expected = expected;
        this.es = es;
        this.started = false;
        this.done = false;
        this.cancelled = false;
        this.lastResult = null;
    }

    private Future<T> submitTask(long delay) {
        this.cf = this.es instanceof ScheduledExecutorService ? ((ScheduledExecutorService)this.es).schedule(this, delay, TimeUnit.MILLISECONDS) : this.es.submit(this);
        return this.cf;
    }

    public Future<T> start(long initialDelay) {
        this.submitTask(initialDelay);
        this.started = true;
        return new RetriableFuture(this);
    }

    @Override
    public final T call() throws Exception {
        boolean _done;
        if (this.retryListener != null) {
            this.retryListener.onBeforeRetry(this);
        }
        T _lastResult = this.execute();
        this.lastResult = _lastResult;
        if (this.retryListener != null) {
            this.retryListener.onAfterRetry(this);
        }
        boolean resultMatch = _lastResult == this.expected || _lastResult != null && _lastResult.compareTo(this.expected) == 0;
        this.done = _done = this.numRetries.get() <= 0 || resultMatch;
        if (_done) {
            if (this.retryListener != null) {
                if (resultMatch) {
                    this.retryListener.onSuccess(this);
                } else {
                    this.retryListener.onFail(this);
                }
            }
        } else {
            this.numRetries.decrementAndGet();
            int _retryInterval = this.randomizingInterval ? ThreadLocalRandom.current().nextInt(this.randomzingRangeLower, this.randomzingRangeUpper) : this.retryInterval;
            this.submitTask(_retryInterval);
        }
        return this.lastResult;
    }

    private T getResult() throws InterruptedException, ExecutionException {
        Comparable value = null;
        if (!this.started || this.cancelled) {
            return null;
        }
        if (!this.cancelled) {
            do {
                value = (Comparable)this.cf.get();
            } while (!this.done && !this.cancelled);
        }
        return (T)value;
    }

    private T getResult(long timeOut, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Comparable value = null;
        if (!this.started || this.cancelled) {
            return null;
        }
        if (!this.cancelled) {
            timeOut = unit.toMillis(timeOut);
            do {
                long start = System.currentTimeMillis();
                value = (Comparable)this.cf.get(timeOut, TimeUnit.MILLISECONDS);
                long end = System.currentTimeMillis();
                long waitedTime = end - start;
                if ((timeOut -= waitedTime) > 0L || this.done || this.cancelled) continue;
                throw new TimeoutException("A retriable task cannot complete before timeout");
            } while (!this.done && !this.cancelled);
        }
        return (T)value;
    }

    public void setRetryListener(RetryListener l) {
        this.retryListener = l;
    }

    public void removeRetryListener() {
        this.retryListener = null;
    }

    public boolean isRetrying() {
        return this.numRetries.get() < this.totalRetries && !this.done;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getNumRetriesSubmited() {
        return this.totalRetries - this.numRetries.get();
    }

    public T getLastResult() {
        return this.lastResult;
    }

    public T getExpectedResult() {
        return this.expected;
    }

    public abstract T execute();

    public boolean isRandomizingInterval() {
        return this.randomizingInterval;
    }

    public void setRandomizingInterval(boolean randomizingInterval) {
        this.randomizingInterval = randomizingInterval;
    }

    public boolean setRandomizingIntervalRange(int lower, int upper) {
        if (!this.randomizingInterval || upper < lower) {
            return false;
        }
        this.randomzingRangeLower = lower;
        this.randomzingRangeUpper = upper;
        return true;
    }

    private class RetriableFuture
    extends FutureTask<T> {
        public RetriableFuture(Callable<T> callable) {
            super(callable);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return RetriableTask.this.getResult();
        }

        @Override
        public T get(long timeOut, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return RetriableTask.this.getResult(timeOut, unit);
        }

        @Override
        public boolean cancel(boolean interrupted) {
            if (RetriableTask.this.done) {
                return false;
            }
            RetriableTask.this.cancelled = true;
            if (RetriableTask.this.cf != null) {
                return RetriableTask.this.cf.cancel(interrupted);
            }
            return true;
        }

        @Override
        public boolean isDone() {
            return RetriableTask.this.done;
        }

        @Override
        public boolean isCancelled() {
            return RetriableTask.this.cancelled;
        }
    }
}

