/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseBatchWorkerCallback;
import jayeson.utility.concurrent.worker.batch.BatchProcessor;
import jayeson.utility.concurrent.worker.batch.BatchTaskProducer;

abstract class BaseSharedExecutorBatchWorker<D, V>
implements BatchTaskProducer<D, V> {
    protected final Queue<D> dataQueue;
    protected final ScheduledExecutorService executor;
    protected final BaseBatchWorkerCallback batchWorkerCallback;
    protected BatchProcessor<D, V> proccesor;
    protected final Object processorLock = new Object();
    protected final int maxBatchSize;
    protected volatile Function<List<D>, V> defaultHandler;

    BaseSharedExecutorBatchWorker(ScheduledExecutorService executor, Queue<D> dataQueue, Function<List<D>, V> defaultHandler, int maxBatchSize, BaseBatchWorkerCallback batchWorkerCallback) {
        this.dataQueue = dataQueue;
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.maxBatchSize = maxBatchSize;
        this.batchWorkerCallback = batchWorkerCallback;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public BaseBatchWorkerCallback getBatchWorkerCallback() {
        return this.batchWorkerCallback;
    }

    public Function<List<D>, V> getDefaultHandler() {
        return this.defaultHandler;
    }

    public int clear() {
        int removeCount = 0;
        while (!this.dataQueue.isEmpty()) {
            this.dataQueue.poll();
            ++removeCount;
        }
        return removeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleProcessor(BatchProcessor currentProcessor) {
        if (this.proccesor == null) {
            Object object = this.processorLock;
            synchronized (object) {
                if (this.proccesor == null) {
                    this.proccesor = currentProcessor != null ? currentProcessor : new BatchProcessor(this, this);
                    this.executor.execute(this.proccesor);
                }
            }
        }
    }

    void processorDone() {
        this.proccesor = null;
    }

    void next(BatchProcessor callingProcessor) {
        this.proccesor = null;
        if (!this.dataQueue.isEmpty()) {
            this.scheduleProcessor(callingProcessor);
        }
    }

    List<D> nextBatch() {
        ArrayList<D> data = new ArrayList<D>();
        while (!this.dataQueue.isEmpty() && data.size() < this.maxBatchSize) {
            data.add(this.dataQueue.poll());
        }
        return data;
    }
}

