/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.SharedExecutorBatchFutureWorker;

public class SharedExecutorBatchFutureWorkerGroup<T, U> {
    private final ScheduledExecutorService executor;
    private final Function<List<T>, CompletableFuture<U>> defaultHandler;
    private final int maxBatchSize;
    private final SharedExecutorBatchFutureWorker.BatchWorkerCallback<T, U> batchWorkerCallback;
    private final ConcurrentHashMap<String, SharedExecutorBatchFutureWorker<T, U>> workers;
    private final boolean waitOnFuture;

    public SharedExecutorBatchFutureWorkerGroup(ScheduledExecutorService executor, Function<List<T>, CompletableFuture<U>> defaultHandler, int maxBatchSizePerWorker, SharedExecutorBatchFutureWorker.BatchWorkerCallback<T, U> batchWorkerCallback, boolean waitOnFuture) {
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.batchWorkerCallback = batchWorkerCallback;
        this.workers = new ConcurrentHashMap();
        this.maxBatchSize = maxBatchSizePerWorker;
        this.waitOnFuture = waitOnFuture;
    }

    public void submit(String streamId, T message) {
        SharedExecutorBatchFutureWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        worker.submit(message);
    }

    public void submit(String streamId, List<T> messages) {
        SharedExecutorBatchFutureWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        worker.submit(messages);
    }

    public int clear(String streamId) {
        SharedExecutorBatchFutureWorker<T, U> worker = this.workers.get(streamId);
        if (worker != null) {
            return worker.clear();
        }
        return -1;
    }

    public int getTotalStreams() {
        return this.workers.size();
    }

    protected SharedExecutorBatchFutureWorker<T, U> createNewWorker(String id) {
        return new SharedExecutorBatchFutureWorker<T, U>(this.executor, this.defaultHandler, this.maxBatchSize, this.batchWorkerCallback, this.waitOnFuture);
    }
}

