/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.SharedExecutorBatchWorker;

public class SharedExecutorBatchWorkerGroup<T, U> {
    protected final ScheduledExecutorService executor;
    protected final Function<List<T>, U> defaultHandler;
    protected final int maxBatchSize;
    protected final SharedExecutorBatchWorker.BatchWorkerCallback<T, U> batchWorkerCallback;
    protected final ConcurrentHashMap<String, SharedExecutorBatchWorker<T, U>> workers;

    public SharedExecutorBatchWorkerGroup(ScheduledExecutorService executor, Function<List<T>, U> defaultHandler, int maxBatchSizePerWorker, SharedExecutorBatchWorker.BatchWorkerCallback<T, U> batchWorkerCallback) {
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.batchWorkerCallback = batchWorkerCallback;
        this.workers = new ConcurrentHashMap();
        this.maxBatchSize = maxBatchSizePerWorker;
    }

    public void submit(String streamId, T message) {
        SharedExecutorBatchWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        worker.submit(message);
    }

    public void submit(String streamId, List<T> messages) {
        SharedExecutorBatchWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        worker.submit(messages);
    }

    public int clear(String streamId) {
        SharedExecutorBatchWorker<T, U> worker = this.workers.get(streamId);
        if (worker != null) {
            return worker.clear();
        }
        return -1;
    }

    public int getTotalStreams() {
        return this.workers.size();
    }

    protected SharedExecutorBatchWorker<T, U> createNewWorker(String id) {
        return new SharedExecutorBatchWorker<T, U>(this.executor, this.defaultHandler, this.maxBatchSize, this.batchWorkerCallback);
    }
}

