/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.crypto;

import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HamcSHA1Context {
    private byte[] key;
    private Mac mac;
    private SecretKeySpec signingKey;
    private static final String ALGO = "HmacSHA1";

    public byte[] getKey() {
        return this.key;
    }

    public Mac getMac() {
        return this.mac;
    }

    public HamcSHA1Context(byte[] key, Mac mac) {
        this.key = key;
        this.mac = mac;
        try {
            this.init();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unable to initialize " + HamcSHA1Context.class.getCanonicalName());
        }
    }

    public HamcSHA1Context(String key) {
        try {
            this.key = key.getBytes();
            this.mac = Mac.getInstance(ALGO);
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize " + HamcSHA1Context.class.getCanonicalName(), e);
        }
    }

    private void init() throws InvalidKeyException {
        this.signingKey = new SecretKeySpec(this.key, ALGO);
        this.mac.init(this.signingKey);
    }
}

