/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.basketball.BasketballMatch;
import jayeson.lib.feed.core.Snapshot;
import jayeson.lib.feed.soccer.SoccerMatch;
import jayeson.lib.feed.tennis.TennisMatch;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableMatch;
import jayeson.model.filter.basketball.FilterableBasketballMatch;
import jayeson.model.filter.soccer.FilterableSoccerMatch;
import jayeson.model.filter.tennis.FilterableTennisMatch;

public class FilterableSnapshot<M extends IBetMatch>
implements ISnapshot<M>,
IFilterWrapper {
    final IDataFilter filter;
    final ISnapshot<M> snapshot;
    private final Map<SportType, Map<String, M>> cachedMatches;
    private final Map<SportType, Map<String, M>> cachedNotPassedMatches;

    public FilterableSnapshot(Collection<M> matches, IDataFilter filter) {
        this((ISnapshot<M>)new Snapshot(matches), filter);
    }

    public FilterableSnapshot(ISnapshot<M> snapshot, IDataFilter filter) {
        this.filter = filter;
        this.snapshot = snapshot;
        this.cachedMatches = new HashMap<SportType, Map<String, M>>();
        this.cachedNotPassedMatches = new HashMap<SportType, Map<String, M>>();
    }

    public Collection<M> matches() {
        return this.applyFilter(this.snapshot.matches(), null).values();
    }

    public Collection<M> matches(SportType type) {
        return this.applyFilter(this.snapshot.matches(type), type).values();
    }

    public Collection<M> unMatches() {
        return this.applyFilter(this.snapshot.matches(), null, true).values();
    }

    public <T extends M> Map<String, T> unMatches(SportType type) {
        return this.applyFilter(this.snapshot.matches(type), type, true);
    }

    public <T extends M> Map<String, T> applyFilter(Collection<M> matches, SportType type) {
        return this.applyFilter(matches, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends M> Map<String, T> applyFilter(Collection<M> matches, SportType type, boolean isNegated) {
        if (!isNegated && this.cachedMatches.containsKey(type)) {
            return this.cachedMatches.get(type);
        }
        if (isNegated && this.cachedNotPassedMatches.containsKey(type)) {
            return this.cachedNotPassedMatches.get(type);
        }
        HashMap<String, FilterableBasketballMatch> passedResults = null;
        HashMap<String, FilterableBasketballMatch> notPassedResults = null;
        FilterableSnapshot filterableSnapshot = this;
        synchronized (filterableSnapshot) {
            if (passedResults == null || notPassedResults == null) {
                passedResults = new HashMap<String, FilterableBasketballMatch>();
                notPassedResults = new HashMap<String, FilterableBasketballMatch>();
                for (IBetMatch match : matches) {
                    FilterableMatch currElement = null;
                    if (match instanceof BasketballMatch) {
                        currElement = new FilterableBasketballMatch((BasketballMatch)match, this.filter, this.snapshot);
                    }
                    if (match instanceof SoccerMatch) {
                        currElement = new FilterableSoccerMatch((SoccerMatch)match, this.filter, this.snapshot);
                    }
                    if (match instanceof TennisMatch) {
                        currElement = new FilterableTennisMatch((TennisMatch)match, this.filter, this.snapshot);
                    }
                    if (this.filter.isPassed(match, this.snapshot)) {
                        passedResults.put(match.id(), (FilterableBasketballMatch)currElement);
                        continue;
                    }
                    notPassedResults.put(match.id(), (FilterableBasketballMatch)currElement);
                }
                this.cachedMatches.put(type, Collections.unmodifiableMap(passedResults));
                this.cachedNotPassedMatches.put(type, Collections.unmodifiableMap(notPassedResults));
            }
        }
        if (!isNegated) {
            return passedResults;
        }
        return notPassedResults;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public <T extends M> Collection<T> matchesOfSport(SportType type) {
        return this.applyFilter(this.snapshot.matchesOfSport(type), type).values();
    }

    public <T extends M> Collection<T> unMatchesOfSport(SportType type) {
        return this.applyFilter(this.snapshot.matchesOfSport(type), type, true).values();
    }

    public Collection<SportType> sports() {
        return this.snapshot.sports();
    }

    public boolean hasMatch(String matchId) {
        IBetMatch match = this.snapshot.match(matchId);
        if (match == null) {
            return false;
        }
        return this.applyFilter(this.snapshot.matches(), null).containsKey(matchId);
    }

    public M match(String matchId) {
        IBetMatch match = this.snapshot.match(matchId);
        if (match != null) {
            match = (IBetMatch)this.applyFilter(this.snapshot.matches(), null).get(matchId);
        }
        return (M)match;
    }
}

