/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.model.IDataFilter;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.IFilterEvent;
import jayeson.model.IFilterEventDispatcher;
import jayeson.model.IFilterEventListener;
import jayeson.model.IMatchFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.IRunnaleFilterRule;
import jayeson.model.filter.event.FilterRequestUpdateEvent;
import jayeson.model.filter.event.RuleRequestUpdateEvent;
import jayeson.model.filterrules.GeneralDataFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class GeneralDataFilter
implements IDataFilter,
IFilterEventDispatcher {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(GeneralDataFilter.class);
    protected Collection<Collection<? extends IDataFilterRule>> filterRulesCollection;
    protected Collection<IMatchFilterRule> matchFilterRules = new ArrayList<IMatchFilterRule>();
    protected Collection<IEventFilterRule> eventFilterRules = new ArrayList<IEventFilterRule>();
    protected Collection<IRecordFilterRule> recordFilterRules = new ArrayList<IRecordFilterRule>();
    @JsonIgnore
    protected volatile int hashCode;
    @JsonIgnore
    private EventBus eventBus;
    @JsonIgnore
    private Collection<IFilterEventListener> listeners;
    @JsonIgnore
    private ObjectMapper mapper;

    public GeneralDataFilter() {
        this.filterRulesCollection = new ArrayList<Collection<? extends IDataFilterRule>>();
        this.filterRulesCollection.add(this.matchFilterRules);
        this.filterRulesCollection.add(this.eventFilterRules);
        this.filterRulesCollection.add(this.recordFilterRules);
        this.eventBus = new EventBus();
        this.listeners = new ArrayList<IFilterEventListener>();
        this.mapper = new ObjectMapper();
    }

    public GeneralDataFilter(GeneralDataFilter filter) {
        this();
        Collection<IDataFilterRule> rules = filter.getFilterRules();
        for (IDataFilterRule rule : rules) {
            if (rule instanceof IRunnaleFilterRule) {
                this.addFilterRule(rule, true);
                continue;
            }
            this.addFilterRule(rule);
        }
    }

    public Object clone() {
        return new GeneralDataFilter(this);
    }

    @Override
    public Collection<IDataFilterRule> getFilterRules() {
        return this.filterRulesCollection.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public void setFilterRules(Collection<IDataFilterRule> filterRules) {
        this.setFilterRules(filterRules, false);
    }

    private void clearRules() {
        this.matchFilterRules.clear();
        this.eventFilterRules.clear();
        this.recordFilterRules.clear();
    }

    @Override
    public void setFilterRules(Collection<IDataFilterRule> filterRules, boolean canListenToRule) {
        this.clearRules();
        for (IDataFilterRule filterRule : filterRules) {
            this.addFilterRule(filterRule, canListenToRule);
        }
    }

    @Override
    public void addFilterRule(IDataFilterRule rule) {
        this.addFilterRule(rule, false);
    }

    @Override
    public void removeFilterRule(IDataFilterRule rule) {
        if (rule instanceof IFilterEventDispatcher) {
            ((IFilterEventDispatcher)((Object)rule)).deregisterListener(this);
        }
        this.matchFilterRules.remove(rule);
        this.eventFilterRules.remove(rule);
        this.recordFilterRules.remove(rule);
    }

    @Override
    public int compareTo(IDataFilter o) {
        if (this.getFilterRules().size() != o.getFilterRules().size()) {
            return -1;
        }
        List comFilterRules = (List)o.getFilterRules();
        for (IDataFilterRule curRule : this.getFilterRules()) {
            boolean notFound = true;
            for (IDataFilterRule comRule : comFilterRules) {
                if (curRule.compareTo(comRule) != 0) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        String output = "";
        try {
            output = this.mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return output;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataFilter) {
            return this.compareTo((IDataFilter)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            result = 17;
            TreeMap<Integer, GeneralDataFilterRule> rules = new TreeMap<Integer, GeneralDataFilterRule>();
            for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
                for (IDataFilterRule iDataFilterRule : filterRules) {
                    GeneralDataFilterRule gRule = (GeneralDataFilterRule)((Object)iDataFilterRule);
                    rules.put(gRule.getRuleType(), gRule);
                }
            }
            for (GeneralDataFilterRule rule : rules.values()) {
                result = 31 * result + rule.hashCode();
            }
            this.hashCode = result;
        }
        return result;
    }

    @Override
    @JsonIgnore
    public boolean isRunnable() {
        for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
            for (IDataFilterRule iDataFilterRule : filterRules) {
                if (!(iDataFilterRule instanceof IRunnaleFilterRule)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setExecutor(ScheduledExecutorService se) {
        for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
            for (IDataFilterRule iDataFilterRule : filterRules) {
                if (!(iDataFilterRule instanceof IRunnaleFilterRule)) continue;
                ((IRunnaleFilterRule)((Object)iDataFilterRule)).setExecutor(se);
            }
        }
    }

    @Override
    public void startAllRunnableRules() {
        for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
            for (IDataFilterRule iDataFilterRule : filterRules) {
                if (!(iDataFilterRule instanceof IRunnaleFilterRule)) continue;
                ((IRunnaleFilterRule)((Object)iDataFilterRule)).start();
            }
        }
    }

    @Override
    public void stopAllRunnableRules() {
        for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
            for (IDataFilterRule iDataFilterRule : filterRules) {
                if (!(iDataFilterRule instanceof IRunnaleFilterRule)) continue;
                ((IRunnaleFilterRule)((Object)iDataFilterRule)).stop();
            }
        }
    }

    @Override
    public void addFilterRule(IDataFilterRule rule, boolean canListenToRule) {
        if (canListenToRule && rule instanceof IFilterEventDispatcher) {
            ((IFilterEventDispatcher)((Object)rule)).registerListener(this);
        }
        if (rule instanceof IMatchFilterRule) {
            this.matchFilterRules.add((IMatchFilterRule)rule);
        }
        if (rule instanceof IEventFilterRule) {
            this.eventFilterRules.add((IEventFilterRule)rule);
        }
        if (rule instanceof IRecordFilterRule) {
            this.recordFilterRules.add((IRecordFilterRule)rule);
        }
    }

    @Override
    public Collection<IFilterEventListener> registeredListeners() {
        return this.listeners;
    }

    @Override
    public EventBus commonBus() {
        return this.eventBus;
    }

    @Subscribe
    public void onRuleChanged(IFilterEvent event) {
        if (event instanceof RuleRequestUpdateEvent) {
            RuleRequestUpdateEvent updatedEvent = (RuleRequestUpdateEvent)event;
            GeneralDataFilter newFilter = (GeneralDataFilter)this.clone();
            newFilter.replaceFilterRule(updatedEvent.getNewRule(), true);
            try {
                this.logger.debug("Dispatch event to Clients.");
                this.dispatchEvent(new FilterRequestUpdateEvent(this, newFilter));
            }
            catch (Exception e) {
                this.logger.error("Filter can not dispatch filer event. ", (Throwable)e);
            }
        } else {
            this.logger.error("Unsupport IFilterEvent : {}.", (Object)event.getClass().getName());
        }
    }

    @Override
    public void replaceFilterRule(IDataFilterRule newRule, boolean canListenToRule) {
        IDataFilterRule oldRule = null;
        block0: for (Collection<? extends IDataFilterRule> filterRules : this.filterRulesCollection) {
            for (IDataFilterRule iDataFilterRule : filterRules) {
                if (!iDataFilterRule.getClass().equals(newRule.getClass())) continue;
                oldRule = iDataFilterRule;
                continue block0;
            }
        }
        if (oldRule != null) {
            this.removeFilterRule(oldRule);
        }
        this.addFilterRule(newRule, canListenToRule);
    }

    @Override
    public boolean isPassed(IBetRecord record, ISnapshot<?> snapshot) {
        for (IDataFilterRule iDataFilterRule : this.recordFilterRules) {
            IRecordFilterRule recordFilterRule;
            if (!(iDataFilterRule instanceof IRecordFilterRule) || (recordFilterRule = (IRecordFilterRule)iDataFilterRule).isPassed(record, snapshot)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPassed(IBetEvent event, ISnapshot<?> snapshot) {
        for (IDataFilterRule iDataFilterRule : this.eventFilterRules) {
            IEventFilterRule eventFilterRule;
            if (!(iDataFilterRule instanceof IEventFilterRule) || (eventFilterRule = (IEventFilterRule)iDataFilterRule).isPassed(event, snapshot)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPassed(IBetMatch match, ISnapshot<?> snapshot) {
        for (IDataFilterRule iDataFilterRule : this.matchFilterRules) {
            IMatchFilterRule matchFilterRule;
            if (!(iDataFilterRule instanceof IMatchFilterRule) || (matchFilterRule = (IMatchFilterRule)iDataFilterRule).isPassed(match, snapshot)) continue;
            return false;
        }
        return true;
    }
}

