/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.basketball;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.basketball.BasketballEvent;
import jayeson.lib.feed.basketball.BasketballEventState;
import jayeson.lib.feed.basketball.BasketballEventType;
import jayeson.lib.feed.basketball.BasketballRecord;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableEvent;

public class FilterableBasketballEvent
extends FilterableEvent<BasketballRecord>
implements BasketballEvent,
IFilterWrapper {
    final BasketballEvent basketballEvent;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<BasketballRecord> cachedRecords;
    private Collection<BasketballRecord> cachedNotPassedRecords;

    public FilterableBasketballEvent(BasketballEvent event, IDataFilter filter, ISnapshot<?> snapshot) {
        this.basketballEvent = event;
        this.filter = filter;
        this.snapshot = snapshot;
    }

    public Collection<BasketballRecord> records() {
        return this.applyFilter(this.basketballEvent.records());
    }

    @Override
    public Collection<BasketballRecord> unRecords() {
        return this.applyFilter(this.basketballEvent.records(), true);
    }

    Collection<BasketballRecord> applyFilter(Collection<BasketballRecord> records) {
        return this.applyFilter(records, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BasketballRecord> applyFilter(Collection<BasketballRecord> records, boolean isNegated) {
        if (!isNegated && this.cachedRecords != null) {
            return this.cachedRecords;
        }
        if (isNegated && this.cachedNotPassedRecords != null) {
            return this.cachedNotPassedRecords;
        }
        if (records == null) {
            this.cachedRecords = Arrays.asList(new BasketballRecord[0]);
            this.cachedNotPassedRecords = this.cachedRecords;
            return this.cachedRecords;
        }
        FilterableBasketballEvent filterableBasketballEvent = this;
        synchronized (filterableBasketballEvent) {
            if (this.cachedRecords == null || this.cachedNotPassedRecords == null) {
                ArrayList<BasketballRecord> results = new ArrayList<BasketballRecord>();
                ArrayList<BasketballRecord> notPassedResults = new ArrayList<BasketballRecord>();
                for (BasketballRecord record : records) {
                    if (this.filter.isPassed((IBetRecord)record, this.snapshot)) {
                        results.add(record);
                        continue;
                    }
                    notPassedResults.add(record);
                }
                this.cachedRecords = Collections.unmodifiableList(results);
                this.cachedNotPassedRecords = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedRecords;
        }
        return this.cachedNotPassedRecords;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public BasketballEventState eventState() {
        return this.basketballEvent.eventState();
    }

    public Collection<BasketballEventState> eventStates() {
        return this.basketballEvent.eventStates();
    }

    public BasketballEventType eventType() {
        return this.basketballEvent.eventType();
    }

    public String id() {
        return this.basketballEvent.id();
    }

    public String matchId() {
        return this.basketballEvent.matchId();
    }

    public Map<String, String> meta() {
        return this.basketballEvent.meta();
    }

    public IBetEventState getEventState(String sportbook) {
        return this.basketballEvent.getEventState(sportbook);
    }
}

