/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.basketball;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.basketball.BasketballEvent;
import jayeson.lib.feed.basketball.BasketballGender;
import jayeson.lib.feed.basketball.BasketballMatch;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableMatch;
import jayeson.model.filter.basketball.FilterableBasketballEvent;

public class FilterableBasketballMatch
extends FilterableMatch<BasketballEvent>
implements BasketballMatch,
IFilterWrapper {
    final BasketballMatch basketballMatch;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<BasketballEvent> cachedEvents;
    private Collection<BasketballEvent> cachedNotPassedEvents;

    public FilterableBasketballMatch(BasketballMatch match, IDataFilter filter, ISnapshot<?> snapshot) {
        this.basketballMatch = match;
        this.filter = filter;
        this.snapshot = snapshot;
    }

    public Collection<BasketballEvent> events() {
        return this.applyFilter(this.basketballMatch.events());
    }

    @Override
    public Collection<BasketballEvent> unEvents() {
        return this.applyFilter(this.basketballMatch.events(), true);
    }

    Collection<BasketballEvent> applyFilter(Collection<BasketballEvent> events) {
        return this.applyFilter(events, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BasketballEvent> applyFilter(Collection<BasketballEvent> events, boolean isNegated) {
        if (!isNegated && this.cachedEvents != null) {
            return this.cachedEvents;
        }
        if (isNegated && this.cachedNotPassedEvents != null) {
            return this.cachedNotPassedEvents;
        }
        if (events == null) {
            this.cachedEvents = Arrays.asList(new BasketballEvent[0]);
            this.cachedNotPassedEvents = this.cachedEvents;
            return this.cachedEvents;
        }
        FilterableBasketballMatch filterableBasketballMatch = this;
        synchronized (filterableBasketballMatch) {
            if (this.cachedEvents == null || this.cachedNotPassedEvents == null) {
                LinkedList<FilterableBasketballEvent> results = new LinkedList<FilterableBasketballEvent>();
                LinkedList<FilterableBasketballEvent> notPassedResults = new LinkedList<FilterableBasketballEvent>();
                for (BasketballEvent event : events) {
                    FilterableBasketballEvent filterableEvent = new FilterableBasketballEvent(event, this.filter, this.snapshot);
                    if (this.filter.isPassed((IBetEvent)event, this.snapshot)) {
                        results.add(filterableEvent);
                        continue;
                    }
                    notPassedResults.add(filterableEvent);
                }
                this.cachedEvents = Collections.unmodifiableList(results);
                this.cachedNotPassedEvents = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedEvents;
        }
        return this.cachedNotPassedEvents;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public BasketballGender gender() {
        return this.basketballMatch.gender();
    }

    public String guest() {
        return this.basketballMatch.guest();
    }

    public String host() {
        return this.basketballMatch.host();
    }

    public String participantOne() {
        return this.basketballMatch.participantOne();
    }

    public String participantTwo() {
        return this.basketballMatch.participantTwo();
    }

    public String getCountry() {
        return this.basketballMatch.getCountry();
    }

    public String id() {
        return this.basketballMatch.id();
    }

    public String league() {
        return this.basketballMatch.league();
    }

    public List<String> participants() {
        return this.basketballMatch.participants();
    }

    public SportType sportType() {
        return this.basketballMatch.sportType();
    }

    public long startTime() {
        return this.basketballMatch.startTime();
    }

    public Map<String, String> meta() {
        return this.basketballMatch.meta();
    }
}

