/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.soccer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.soccer.LeagueType;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.lib.feed.soccer.SoccerGender;
import jayeson.lib.feed.soccer.SoccerMatch;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableMatch;
import jayeson.model.filter.soccer.FilterableSoccerEvent;

public class FilterableSoccerMatch
extends FilterableMatch<SoccerEvent>
implements SoccerMatch,
IFilterWrapper {
    final SoccerMatch soccerMatch;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<SoccerEvent> cachedEvents;
    private Collection<SoccerEvent> cachedNotPassedEvents;

    public FilterableSoccerMatch(SoccerMatch match, IDataFilter filter, ISnapshot<?> snapshot) {
        this.soccerMatch = match;
        this.filter = filter;
        this.snapshot = snapshot;
    }

    public Collection<SoccerEvent> events() {
        return this.applyFilter(this.soccerMatch.events());
    }

    @Override
    public Collection<SoccerEvent> unEvents() {
        return this.applyFilter(this.soccerMatch.events(), true);
    }

    Collection<SoccerEvent> applyFilter(Collection<SoccerEvent> events) {
        return this.applyFilter(events, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SoccerEvent> applyFilter(Collection<SoccerEvent> events, boolean isNegated) {
        if (!isNegated && this.cachedEvents != null) {
            return this.cachedEvents;
        }
        if (isNegated && this.cachedNotPassedEvents != null) {
            return this.cachedNotPassedEvents;
        }
        if (events == null) {
            this.cachedEvents = Arrays.asList(new SoccerEvent[0]);
            this.cachedNotPassedEvents = this.cachedEvents;
            return this.cachedEvents;
        }
        FilterableSoccerMatch filterableSoccerMatch = this;
        synchronized (filterableSoccerMatch) {
            if (this.cachedEvents == null || this.cachedNotPassedEvents == null) {
                LinkedList<FilterableSoccerEvent> results = new LinkedList<FilterableSoccerEvent>();
                LinkedList<FilterableSoccerEvent> notPassedResults = new LinkedList<FilterableSoccerEvent>();
                for (SoccerEvent event : events) {
                    FilterableSoccerEvent filterableEvent = new FilterableSoccerEvent(event, this.filter, this.snapshot);
                    if (this.filter.isPassed((IBetEvent)event, this.snapshot)) {
                        results.add(filterableEvent);
                        continue;
                    }
                    notPassedResults.add(filterableEvent);
                }
                this.cachedEvents = Collections.unmodifiableList(results);
                this.cachedNotPassedEvents = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedEvents;
        }
        return this.cachedNotPassedEvents;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public String participantOne() {
        return this.soccerMatch.participantOne();
    }

    public String participantTwo() {
        return this.soccerMatch.participantTwo();
    }

    public String getCountry() {
        return this.soccerMatch.getCountry();
    }

    public String id() {
        return this.soccerMatch.id();
    }

    public String league() {
        return this.soccerMatch.league();
    }

    public List<String> participants() {
        return this.soccerMatch.participants();
    }

    public SportType sportType() {
        return this.soccerMatch.sportType();
    }

    public long startTime() {
        return this.soccerMatch.startTime();
    }

    public Map<String, String> meta() {
        return this.soccerMatch.meta();
    }

    public SoccerGender gender() {
        return this.soccerMatch.gender();
    }

    public String guest() {
        return this.soccerMatch.guest();
    }

    public String host() {
        return this.soccerMatch.host();
    }

    public LeagueType leagueType() {
        return this.soccerMatch.leagueType();
    }
}

