/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.tennis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.tennis.TennisEvent;
import jayeson.lib.feed.tennis.TennisEventState;
import jayeson.lib.feed.tennis.TennisEventType;
import jayeson.lib.feed.tennis.TennisRecord;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableEvent;

public class FilterableTennisEvent
extends FilterableEvent<TennisRecord>
implements TennisEvent,
IFilterWrapper {
    final TennisEvent tennisEvent;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<TennisRecord> cachedRecords;
    private Collection<TennisRecord> cachedNotPassedRecords;

    public FilterableTennisEvent(TennisEvent event, IDataFilter filter, ISnapshot<?> snapshot) {
        this.tennisEvent = event;
        this.filter = filter;
        this.snapshot = snapshot;
    }

    public Collection<TennisRecord> records() {
        return this.applyFilter(this.tennisEvent.records());
    }

    @Override
    public Collection<TennisRecord> unRecords() {
        return this.applyFilter(this.tennisEvent.records(), true);
    }

    Collection<TennisRecord> applyFilter(Collection<TennisRecord> records) {
        return this.applyFilter(records, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<TennisRecord> applyFilter(Collection<TennisRecord> records, boolean isNegated) {
        if (!isNegated && this.cachedRecords != null) {
            return this.cachedRecords;
        }
        if (isNegated && this.cachedNotPassedRecords != null) {
            return this.cachedNotPassedRecords;
        }
        if (records == null) {
            this.cachedRecords = Arrays.asList(new TennisRecord[0]);
            this.cachedNotPassedRecords = this.cachedRecords;
            return this.cachedRecords;
        }
        FilterableTennisEvent filterableTennisEvent = this;
        synchronized (filterableTennisEvent) {
            if (this.cachedRecords == null || this.cachedNotPassedRecords == null) {
                ArrayList<TennisRecord> results = new ArrayList<TennisRecord>();
                ArrayList<TennisRecord> notPassedResults = new ArrayList<TennisRecord>();
                for (TennisRecord record : records) {
                    if (this.filter.isPassed((IBetRecord)record, this.snapshot)) {
                        results.add(record);
                        continue;
                    }
                    notPassedResults.add(record);
                }
                this.cachedRecords = Collections.unmodifiableList(results);
                this.cachedNotPassedRecords = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedRecords;
        }
        return this.cachedNotPassedRecords;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public String id() {
        return this.tennisEvent.id();
    }

    public String matchId() {
        return this.tennisEvent.matchId();
    }

    public Map<String, String> meta() {
        return this.tennisEvent.meta();
    }

    public TennisEventState eventState() {
        return this.tennisEvent.eventState();
    }

    public Collection<TennisEventState> eventStates() {
        return this.tennisEvent.eventStates();
    }

    public TennisEventType eventType() {
        return this.tennisEvent.eventType();
    }

    public IBetEventState getEventState(String sportbook) {
        return this.tennisEvent.getEventState(sportbook);
    }
}

