/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class CompanyFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private Collection<String> includeCompanies = new HashSet<String>();
    private Collection<String> excludeCompanies = new HashSet<String>();

    public CompanyFilterRule() {
        this.ruleType = 10;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        String company = record.source().toLowerCase();
        for (String excludeCompany : this.excludeCompanies) {
            if (!company.toLowerCase().equals(excludeCompany.toLowerCase()) || excludeCompany.length() <= 0) continue;
            return false;
        }
        if (this.includeCompanies.isEmpty()) {
            return true;
        }
        for (String includeCompany : this.includeCompanies) {
            if (includeCompany.length() == 0) {
                return true;
            }
            if (!company.toLowerCase().equals(includeCompany.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getIncludeCompanies() {
        return this.includeCompanies;
    }

    public void setIncludeCompanies(Collection<String> includeCompanies) {
        this.includeCompanies.clear();
        for (String item : includeCompanies) {
            this.includeCompanies.add(item.toLowerCase());
        }
    }

    public Collection<String> getExcludeCompanies() {
        return this.excludeCompanies;
    }

    public void setExcludeCompanies(Collection<String> excludeCompanies) {
        this.excludeCompanies.clear();
        for (String item : excludeCompanies) {
            this.excludeCompanies.add(item.toLowerCase());
        }
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof CompanyFilterRule) {
            boolean notFound;
            CompanyFilterRule rule = (CompanyFilterRule)o;
            if (this.includeCompanies.size() != rule.getIncludeCompanies().size()) {
                return -1;
            }
            for (String curKeywords : this.includeCompanies) {
                notFound = true;
                for (String comKeywords : rule.getIncludeCompanies()) {
                    if (!curKeywords.equals(comKeywords)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            if (this.excludeCompanies.size() != rule.getExcludeCompanies().size()) {
                return -1;
            }
            for (String curKeywords : this.excludeCompanies) {
                notFound = true;
                for (String comKeywords : rule.getExcludeCompanies()) {
                    if (!curKeywords.equals(comKeywords)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.includeCompanies == null || this.includeCompanies.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<String> inCompanies = new TreeSet<String>();
            inCompanies.addAll(this.includeCompanies);
            for (String company : inCompanies) {
                result = 31 * result + company.hashCode();
            }
        }
        if (this.excludeCompanies == null || this.excludeCompanies.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<String> exCompanies = new TreeSet<String>();
            exCompanies.addAll(this.excludeCompanies);
            for (String company : exCompanies) {
                result = 31 * result + company.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

