/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class EventTypeFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private Set<EventType> eventTypes = new HashSet<EventType>();

    public EventTypeFilterRule() {
        this.ruleType = 19;
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(Set<EventType> eventTypes) {
        this.eventTypes = eventTypes;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        if (this.eventTypes.isEmpty()) {
            return true;
        }
        return this.eventTypes.contains(event.eventType());
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof EventTypeFilterRule) {
            EventTypeFilterRule rule = (EventTypeFilterRule)o;
            if (this.eventTypes.size() != rule.getEventTypes().size()) {
                return -1;
            }
            if (!this.eventTypes.equals(rule.getEventTypes())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.eventTypes == null || this.eventTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<EventType> eventTypesSet = new TreeSet<EventType>(new EventTypeComparator());
            eventTypesSet.addAll(this.eventTypes);
            for (EventType eventType : eventTypesSet) {
                result = 31 * result + eventType.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    private class EventTypeComparator
    implements Comparator<EventType> {
        private EventTypeComparator() {
        }

        @Override
        public int compare(EventType o1, EventType o2) {
            if (o1.getClass() != o2.getClass()) {
                return Integer.MIN_VALUE;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

