/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.LBType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class LayBackTypeFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    List<LBType> types = new ArrayList<LBType>();

    public LayBackTypeFilterRule() {
        this.ruleType = 2;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        boolean isComplied = false;
        for (LBType type : this.types) {
            if (record.lbType() != type) continue;
            isComplied = true;
        }
        return isComplied;
    }

    public List<LBType> getTypes() {
        return this.types;
    }

    public void setTypes(List<LBType> types) {
        this.types.clear();
        this.types.addAll(types);
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof LayBackTypeFilterRule) {
            LayBackTypeFilterRule rule = (LayBackTypeFilterRule)o;
            if (this.getTypes().size() != rule.getTypes().size()) {
                return -1;
            }
            for (LBType curType : this.getTypes()) {
                boolean notFound = true;
                for (LBType comType : rule.getTypes()) {
                    if (!curType.equals((Object)comType)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        TreeSet<LBType> LBTypes = new TreeSet<LBType>();
        LBTypes.addAll(this.types);
        for (LBType type : LBTypes) {
            result = 31 * result + type.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

