/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class LeagueHashCodeFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private Set<String> leagueHashCodes = new TreeSet<String>();

    public LeagueHashCodeFilterRule() {
        this.ruleType = 27;
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        String leagueHashCode = String.format("%s", match.league().hashCode());
        return this.leagueHashCodes.contains(leagueHashCode);
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.leagueHashCodes == null || this.leagueHashCodes.isEmpty()) {
            result = 31 * result;
        } else {
            for (String league : this.leagueHashCodes) {
                result = 31 * result + league.hashCode();
            }
        }
        return result;
    }

    public Set<String> getLeagueHashCodes() {
        return this.leagueHashCodes;
    }

    public void setLeagueHashCodes(Set<String> leagueHashCodes) {
        this.leagueHashCodes = leagueHashCodes;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof LeagueHashCodeFilterRule) {
            LeagueHashCodeFilterRule rule = (LeagueHashCodeFilterRule)o;
            if (!this.leagueHashCodes.equals(rule.getLeagueHashCodes())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }
}

