/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.OddType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class MarketFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private OddType monitorMarketType = OddType.LIVE;

    public MarketFilterRule() {
        this.ruleType = 4;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        OddType recordMarketType = record.oddType();
        boolean passed = false;
        if (this.monitorMarketType == OddType.LIVE && recordMarketType == OddType.LIVE) {
            passed = true;
        } else if (this.monitorMarketType == OddType.TODAY && recordMarketType == OddType.TODAY) {
            passed = true;
        } else if (this.monitorMarketType == OddType.EARLY && recordMarketType == OddType.EARLY) {
            passed = true;
        }
        return passed;
    }

    public OddType getMonitorMarketType() {
        return this.monitorMarketType;
    }

    public void setMonitorMarketType(OddType monitorMarketType) {
        this.monitorMarketType = monitorMarketType;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof MarketFilterRule) {
            MarketFilterRule rule = (MarketFilterRule)o;
            if (this.getMonitorMarketType() != rule.getMonitorMarketType()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (this.monitorMarketType == null ? 0 : this.monitorMarketType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

