/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.OddType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class OddTypeFilterRule
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private List<OddType> oddTypes = new ArrayList<OddType>();

    public OddTypeFilterRule() {
        this.ruleType = 15;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        for (OddType oddType : this.oddTypes) {
            if (oddType != record.oddType()) continue;
            return true;
        }
        return false;
    }

    public List<OddType> getOddTypes() {
        return this.oddTypes;
    }

    public void setOddTypes(List<OddType> oddTypes) {
        this.oddTypes = oddTypes;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof OddTypeFilterRule) {
            OddTypeFilterRule rule = (OddTypeFilterRule)o;
            if (this.getOddTypes().size() != rule.getOddTypes().size()) {
                return -1;
            }
            for (OddType oddType : this.oddTypes) {
                boolean notFound = true;
                for (OddType oddType1 : rule.getOddTypes()) {
                    if (oddType != oddType1) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return result;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.oddTypes == null || this.oddTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<OddType> oTypes = new TreeSet<OddType>();
            oTypes.addAll(this.oddTypes);
            for (OddType type : oTypes) {
                result = 31 * result + type.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

