/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IFilterEventDispatcher;
import jayeson.model.IFilterEventListener;
import jayeson.model.IMatchFilterRule;
import jayeson.model.IRunnaleFilterRule;
import jayeson.model.filter.event.RuleRequestUpdateEvent;
import jayeson.model.filterrules.GeneralDataFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class RelativeStartTimeRangeFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule,
IRunnaleFilterRule,
IFilterEventDispatcher {
    private long baseTime;
    private long startTimeLower;
    private long startTimeUpper;
    private static final long CHANGE_INTERVAL = 86400L;
    private static Logger logger = LoggerFactory.getLogger(RelativeStartTimeRangeFilterRule.class);
    @JsonIgnore
    private EventBus eventBus;
    @JsonIgnore
    private Collection<IFilterEventListener> listeners;
    @JsonIgnore
    private ScheduledExecutorService baseTimeExecutor;
    @JsonIgnore
    private ScheduledFuture baseTimeFuture;

    public RelativeStartTimeRangeFilterRule() {
        this.startTimeLower = 0L;
        this.startTimeUpper = 0L;
        this.setBaseTime();
        this.eventBus = new EventBus();
        this.listeners = new ArrayList<IFilterEventListener>();
        this.ruleType = 17;
    }

    public RelativeStartTimeRangeFilterRule(RelativeStartTimeRangeFilterRule rule) {
        super(rule);
        this.startTimeLower = rule.startTimeLower;
        this.startTimeUpper = rule.startTimeUpper;
        this.baseTime = rule.baseTime;
        this.eventBus = new EventBus();
        this.listeners = new ArrayList<IFilterEventListener>();
    }

    public Date baseDate() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date epoch = calendar.getTime();
        if (currentDate.before(epoch)) {
            calendar.add(5, -1);
        }
        return calendar.getTime();
    }

    @Override
    public void setExecutor(ScheduledExecutorService se) {
        this.baseTimeExecutor = se;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new RelativeStartTimeRangeFilterRule(this);
    }

    @JsonIgnore
    public long getInitialDelay() {
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date epoch = calendar.getTime();
        if (!currentDate.before(epoch)) {
            calendar.add(5, 1);
        }
        Date nextNoon = calendar.getTime();
        return nextNoon.getTime() - currentDate.getTime();
    }

    @Override
    public void start() {
        if (this.baseTimeFuture == null && this.baseTimeExecutor != null) {
            this.baseTimeFuture = this.baseTimeExecutor.schedule(this, this.getInitialDelay(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.baseTimeFuture != null && this.baseTimeExecutor != null) {
            this.baseTimeFuture.cancel(false);
            this.baseTimeFuture = null;
        }
    }

    @Override
    private boolean isComplied(long startTime) {
        return this.inRange(this.baseTime + this.startTimeLower, this.baseTime + this.startTimeUpper, startTime);
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        return this.isComplied(match.startTime());
    }

    protected boolean inRange(long lower, long upper, long num) {
        Date lowerDate = new Date(lower * 1000L);
        Date upperDate = new Date(upper * 1000L);
        Date comparedDate = new Date(num * 1000L);
        return comparedDate.after(lowerDate) && comparedDate.before(upperDate);
    }

    public long getStartTimeLower() {
        return this.startTimeLower;
    }

    public long getStartTimeUpper() {
        return this.startTimeUpper;
    }

    public void setStartTimeLower(long startTimeLower) {
        this.startTimeLower = startTimeLower;
    }

    public void setStartTimeUpper(long startTimeUpper) {
        this.startTimeUpper = startTimeUpper;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof RelativeStartTimeRangeFilterRule) {
            RelativeStartTimeRangeFilterRule rule = (RelativeStartTimeRangeFilterRule)o;
            if (this.getStartTimeLower() != rule.getStartTimeLower()) {
                return -1;
            }
            if (this.getStartTimeUpper() != rule.getStartTimeUpper()) {
                return -1;
            }
            if (this.getBaseTime() != rule.getBaseTime()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (int)(this.baseTime ^ this.baseTime >>> 32);
        result = 31 * result + (int)(this.startTimeLower ^ this.startTimeLower >>> 32);
        result = 31 * result + (int)(this.startTimeUpper ^ this.startTimeUpper >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public void setBaseTime() {
        Date baseEpoch = this.baseDate();
        this.baseTime = baseEpoch.getTime() / 1000L;
        logger.trace("baseTime : {}", (Object)this.baseTime);
    }

    public void setBaseTime(long seconds) {
        this.baseTime = seconds;
    }

    @Override
    public void run() {
        RelativeStartTimeRangeFilterRule newRule = new RelativeStartTimeRangeFilterRule(this);
        newRule.baseTime += 86400L;
        RuleRequestUpdateEvent event = new RuleRequestUpdateEvent(this, newRule);
        try {
            logger.debug("Dispatch event to filter.");
            this.dispatchEvent(event);
        }
        catch (Exception e) {
            logger.error("Cannot dispatch event to filter.", (Throwable)e);
        }
    }

    @Override
    public Collection<IFilterEventListener> registeredListeners() {
        return this.listeners;
    }

    @Override
    public EventBus commonBus() {
        return this.eventBus;
    }
}

