/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.model.IDataFilterRule;
import jayeson.model.IEventFilterRule;
import jayeson.model.filterrules.FilterOperator;
import jayeson.model.filterrules.GeneralDataFilterRule;
import jayeson.model.filterrules.OperatorSubject;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class ScoreFilterRule
extends GeneralDataFilterRule
implements IEventFilterRule {
    private FilterOperator operator = FilterOperator.FILTER_IGNORED;
    private OperatorSubject subject = OperatorSubject.HOST;
    private int score;

    public ScoreFilterRule() {
        this.ruleType = 7;
    }

    @Override
    public boolean isComplied(IBetEvent event) {
        if (this.operator == FilterOperator.FILTER_IGNORED) {
            return true;
        }
        if (!(event instanceof SoccerEvent)) {
            throw new UnsupportedOperationException();
        }
        SoccerEvent evt = (SoccerEvent)event;
        int hostPoint = evt.eventState().hostScore();
        int guestPoint = evt.eventState().guestScore();
        switch (this.subject) {
            case HOST: {
                return this.isCompliedByScore(this.operator, hostPoint, this.score);
            }
            case GUEST: {
                return this.isCompliedByScore(this.operator, guestPoint, this.score);
            }
            case DIFFERENCE: {
                int scoreDiff = Math.abs(hostPoint - guestPoint);
                return this.isCompliedByScore(this.operator, scoreDiff, this.score);
            }
            case HOST_LEADING: {
                int hostLeading = hostPoint - guestPoint;
                return this.isCompliedByScore(this.operator, hostLeading, this.score);
            }
            case GUEST_LEADING: {
                int guestLeading = guestPoint - hostPoint;
                return this.isCompliedByScore(this.operator, guestLeading, this.score);
            }
            case TOTAL: {
                int totalScore = hostPoint + guestPoint;
                return this.isCompliedByScore(this.operator, totalScore, this.score);
            }
        }
        return false;
    }

    private boolean isCompliedByScore(FilterOperator filterType, int score, int criteria) {
        if (criteria >= 0) {
            switch (filterType) {
                case FILTER_LARGER: {
                    return score > criteria;
                }
                case FILTER_LARGER_EQUAL: {
                    return score >= criteria;
                }
                case FILTER_EQUAL: {
                    return score == criteria;
                }
                case FILTER_SMALLER_EQUAL: {
                    return score <= criteria;
                }
                case FILTER_SMALLER: {
                    return score < criteria;
                }
            }
            return true;
        }
        return true;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public OperatorSubject getSubject() {
        return this.subject;
    }

    public void setSubject(OperatorSubject subject) {
        this.subject = subject;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof ScoreFilterRule) {
            ScoreFilterRule rule = (ScoreFilterRule)o;
            if (this.getScore() != rule.getScore()) {
                return -1;
            }
            if (!this.getOperator().equals((Object)rule.getOperator())) {
                return -1;
            }
            if (!this.getSubject().equals((Object)rule.getSubject())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + this.score;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

