/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;
import jayeson.model.filterrules.TimePivotType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class TimePivotTypeFilterRule<T extends TimeType>
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private Set<TimePivotType<T>> timePivotTypes = new HashSet<TimePivotType<T>>();

    public TimePivotTypeFilterRule() {
        this.ruleType = 20;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        if (!(record instanceof IB2Record)) {
            return false;
        }
        IB2Record b2Record = (IB2Record)record;
        if (this.timePivotTypes.isEmpty()) {
            return true;
        }
        for (TimePivotType<T> timePivotType : this.timePivotTypes) {
            if (!b2Record.timeType().equals(timePivotType.getTimeType()) || !b2Record.pivotType().equals((Object)timePivotType.getPivotType())) continue;
            return true;
        }
        return false;
    }

    public Set<TimePivotType<T>> getTimePivotTypes() {
        return this.timePivotTypes;
    }

    public void setTimePivotTypes(Set<TimePivotType<T>> timePivotTypes) {
        this.timePivotTypes = timePivotTypes;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.timePivotTypes == null || this.timePivotTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<TimePivotType<T>> timePivotTypeTreeSet = new TreeSet<TimePivotType<T>>();
            timePivotTypeTreeSet.addAll(this.timePivotTypes);
            for (TimePivotType timePivotType : timePivotTypeTreeSet) {
                result = 31 * result + timePivotType.hashCode();
            }
        }
        return result;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof TimePivotTypeFilterRule) {
            TimePivotTypeFilterRule rule = (TimePivotTypeFilterRule)o;
            if (this.timePivotTypes.size() != rule.getTimePivotTypes().size()) {
                return -1;
            }
            for (TimePivotType<T> timePivotType : this.timePivotTypes) {
                if (rule.timePivotTypes.contains(timePivotType)) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

