/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.TimeType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IRecordFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class TimeTypeFilterRule<T extends TimeType>
extends GeneralDataFilterRule
implements IRecordFilterRule {
    private List<T> types = new ArrayList<T>();

    public TimeTypeFilterRule() {
        this.ruleType = 12;
    }

    @Override
    public boolean isComplied(IBetRecord record) {
        boolean isComplied = false;
        for (TimeType type : this.types) {
            if (!record.timeType().equals(type)) continue;
            isComplied = true;
        }
        return isComplied;
    }

    public List<T> getTypes() {
        return this.types;
    }

    public void setTypes(List<T> types) {
        this.types = types;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof TimeTypeFilterRule) {
            TimeTypeFilterRule rule = (TimeTypeFilterRule)o;
            if (this.getTypes().size() != rule.getTypes().size()) {
                return -1;
            }
            for (TimeType curType : this.getTypes()) {
                boolean notFound = true;
                for (TimeType comType : rule.getTypes()) {
                    if (!curType.equals(comType)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.types == null || this.types.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<TimeType> tTypes = new TreeSet<TimeType>(new TimeTypeComparator());
            tTypes.addAll(this.types);
            for (TimeType type : tTypes) {
                result = 31 * result + type.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    private class TimeTypeComparator
    implements Comparator<TimeType> {
        private TimeTypeComparator() {
        }

        @Override
        public int compare(TimeType o1, TimeType o2) {
            if (o1.getClass() != o2.getClass()) {
                return Integer.MIN_VALUE;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

